---
generated_at: 2026-01-29 12:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：88-フィードバックページ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `apps/portal/src/components/pages/feedback-page.js` - メインページコンポーネント
- E-02: `apps/portal/src/pages.js` - ページルーティング定義
- E-03: `apps/portal/src/app-context.js` - アプリケーションコンテキスト
- E-04: `apps/portal/src/utils/api.js` - API通信処理
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FeedbackPageがフィードバックページのメインコンポーネントである | E-01 (308行目), E-02 (12, 36行目) | ○ |
| C-02 | pageDataにuuid, key, postId, scoreを持つ | E-01 (310行目) | ○ |
| C-03 | stateにscore, confirmed, loading, errorを持つ | E-01 (311-317行目) | ○ |
| C-04 | isLoggedInでmember有無判定 | E-01 (313行目 !!member) | ○ |
| C-05 | ログイン済みはconfirmed=true, loading=true初期値 | E-01 (315-316行目) | ○ |
| C-06 | ConfirmDialogコンポーネントで確認ダイアログ表示 | E-01 (201-264行目) | ○ |
| C-07 | score=1が"More like this"、score=0が"Less like this" | E-01 (233, 242行目) | ○ |
| C-08 | setScoreでスコア状態更新 | E-01 (203, 235, 244行目) | ○ |
| C-09 | getButtonClassNamesで選択状態スタイル | E-01 (218-221行目) | ○ |
| C-10 | brandColorで選択ボタンハイライト | E-01 (223-225行目) | ○ |
| C-11 | "Submit feedback"ボタンラベル | E-01 (257行目) | ○ |
| C-12 | sendFeedbackでapi.feedback.add呼び出し | E-01 (266-269行目) | ○ |
| C-13 | api.feedback.addでPOST送信 | E-04 (139-168行目) | ○ |
| C-14 | uuid/keyをクエリパラメータに追加 | E-04 (142-144行目) | ○ |
| C-15 | doSendFeedbackでエラーハンドリング | E-01 (319-329行目) | ○ |
| C-16 | chooseBestErrorMessageでエラーメッセージ取得 | E-01 (325行目) | ○ |
| C-17 | LoadingFeedbackViewで自動送信 | E-01 (271-277行目) | ○ |
| C-18 | ConfirmFeedbackで完了画面表示 | E-01 (279-306行目) | ○ |
| C-19 | positiveに応じてアイコン切り替え | E-01 (282行目) | ○ |
| C-20 | "Thanks for the feedback!"タイトル | E-01 (291行目) | ○ |
| C-21 | ErrorPageでエラー画面表示 | E-01 (173-199行目) | ○ |
| C-22 | "Sorry, that didn't work."エラータイトル | E-01 (182行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UI表示ロジック
- 0: 低リスク - フィードバック送信処理
- 0: 低リスク - ログイン状態による表示分岐

## 6) レビュアーチェックリスト（最小）
- [ ] FeedbackPageコンポーネントの構造が設計書と一致しているか確認
- [ ] ログイン状態による自動送信ロジックが正しいか確認
- [ ] score値（0/1）の意味が正しく記載されているか確認
- [ ] API呼び出し時のuuid/keyパラメータ処理が正しいか確認
