---
generated_at: 2026-01-29 21:25:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-サイト画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/admin/app/routes/site.js` - サイトルート
- E-02: `ghost/admin/app/controllers/site.js` - サイトコントローラー
- E-03: `ghost/admin/app/templates/site.hbs` - サイトテンプレート
- E-04: `ghost/admin/app/components/gh-site-iframe.js` - iframeコンポーネントJS
- E-05: `ghost/admin/app/components/gh-site-iframe.hbs` - iframeコンポーネントテンプレート
- E-06: `ghost/admin/app/routes/authenticated.js` - 認証済みルート基底クラス
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL: /ghost/site | E-01, E-07 | ○ |
| C-02 | GhSiteIframeコンポーネントを使用 | E-03 (1行目) | ○ |
| C-03 | AuthenticatedRouteを継承 | E-01 (1行目, 3行目) | ○ |
| C-04 | modelでタイムスタンプ生成 | E-01 (4-6行目) | ○ |
| C-05 | guidはmodelのエイリアス | E-02 (7-8行目) | ○ |
| C-06 | srcUrlでblogUrl+guidパラメータ生成 | E-04 (21-29行目) | ○ |
| C-07 | guid変更時にresetSrcAttribute実行 | E-04 (31-56行目), E-05 (8行目) | ○ |
| C-08 | iframeにframeborder="0"設定 | E-05 (4行目) | ○ |
| C-09 | iframeにallowtransparency="true"設定 | E-05 (5行目) | ○ |
| C-10 | SecurityError時にiframe.srcを直接設定 | E-04 (48-51行目) | ○ |
| C-11 | onLoadでiframe参照を保存 | E-04 (59-67行目) | ○ |
| C-12 | テーマ管理（機能No.30）に関連 | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし。全ての主張に対して十分な根拠が確認できた。

## 5) リスクフラグ（レビュー観点）

- **0（低リスク）**：iframeの動作 - コンポーネントから明確に確認可能
- **0（低リスク）**：URL生成ロジック - srcUrlゲッターから確認可能
- **0（低リスク）**：リロード処理 - resetSrcAttributeから確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] config.blogUrlが正しく設定されているか確認
- [ ] iframeのセキュリティエラー処理が期待通りに動作するか確認
- [ ] ナビゲーション再クリック時のリロードが正しく動作するか確認
- [ ] クロスオリジン制約によるiframe操作制限を確認
