---
generated_at: 2026-01-29 12:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：90-サポートページ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `apps/portal/src/components/pages/support-page.js` - メインページコンポーネント
- E-02: `apps/portal/src/components/pages/support-error.js` - エラー画面コンポーネント
- E-03: `apps/portal/src/pages.js` - ページルーティング定義
- E-04: `apps/portal/src/app-context.js` - アプリケーションコンテキスト
- E-05: `apps/portal/src/utils/api.js` - API通信処理
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SupportPageがサポートページのメインコンポーネントである | E-01 (8行目), E-03 (16, 40行目) | ○ |
| C-02 | stateにisLoading, error, disabledFeatureErrorを持つ | E-01 (9-11行目) | ○ |
| C-03 | AppContextからmember, siteを取得 | E-01 (12行目) | ○ |
| C-04 | useEffectでcheckoutDonation実行 | E-01 (14-48行目) | ○ |
| C-05 | donations_enabled=false時にdisabledFeatureError設定 | E-01 (39-41行目) | ○ |
| C-06 | "This site is not accepting donations at the moment."メッセージ | E-01 (40行目) | ○ |
| C-07 | successUrlはmember有無で分岐 | E-01 (18行目) | ○ |
| C-08 | ログイン済み時"?action=support&success=true" | E-01 (18行目) | ○ |
| C-09 | 未ログイン時"#/portal/support/success" | E-01 (18行目) | ○ |
| C-10 | api.member.checkoutDonation呼び出し | E-01 (23行目) | ○ |
| C-11 | personalNoteに"Add a personal note"設定 | E-01 (23行目) | ○ |
| C-12 | response.url存在時にwindow.location.replace | E-01 (25-27行目) | ○ |
| C-13 | DisabledFeatureError時の分岐処理 | E-01 (29-30行目) | ○ |
| C-14 | "This site is not accepting payments at the moment."メッセージ | E-01 (30行目) | ○ |
| C-15 | 一般エラー時"Something went wrong, please try again later." | E-01 (32行目) | ○ |
| C-16 | api.member.checkoutDonationでPOST送信 | E-05 (511-551行目) | ○ |
| C-17 | type: 'donation'をボディに含む | E-05 (526行目) | ○ |
| C-18 | SupportErrorコンポーネントでエラー表示 | E-01 (59, 64行目), E-02 (28-61行目) | ○ |
| C-19 | SupportErrorでSentryエラーログ | E-02 (34-36行目) | ○ |
| C-20 | エラータイトル"Sorry, that didn't work." | E-02 (30行目) | ○ |
| C-21 | デフォルトエラー"There was an error processing your payment. Please try again." | E-02 (31行目) | ○ |
| C-22 | supportとしてページ登録 | E-03 (40行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UI表示ロジック
- 0: 低リスク - Stripe決済連携
- 0: 低リスク - エラーハンドリング

## 6) レビュアーチェックリスト（最小）
- [ ] SupportPageコンポーネントの構造が設計書と一致しているか確認
- [ ] useEffectによるcheckoutDonation自動実行が正しく記載されているか確認
- [ ] successUrl/cancelUrlの計算ロジックが正しいか確認
- [ ] donations_enabled判定とエラーハンドリングが正しいか確認
