---
generated_at: 2026-01-29 21:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：91-レコメンデーションページ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **データベーステーブル名**：推測に基づく記載

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `apps/portal/src/components/pages/recommendations-page.js` (1-376行目)
- E-02: `apps/portal/src/pages.js` (1-67行目)
- E-03: `apps/portal/src/App.js` (498-507行目、900-907行目)
- E-04: `apps/portal/src/utils/api.js` (121-136行目、170-179行目)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (143-144行目)
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` (92行目)
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md` (311-335行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RecommendationsPageはPortalの公開画面である | E-02 (L43), E-06 | ○ |
| C-02 | サインアップ成功後に自動リダイレクトされる | E-03 (L498-507) | ○ |
| C-03 | URLハッシュ `#/portal/recommendations` でアクセス可能 | E-03 (L900-907) | ○ |
| C-04 | レコメンデーションはシャッフルされる | E-01 (L148-163, L288-298) | ○ |
| C-05 | ワンクリック購読対応サイトが先に表示される | E-01 (L290-297) | ○ |
| C-06 | 初期表示は5件 | E-01 (L306) | ○ |
| C-07 | visitHandlerで新規タブを開く | E-01 (L179-187, L216-224) | ○ |
| C-08 | trackRecommendationClickedでクリック追跡 | E-01 (L221), E-04 (L171-174) | ○ |
| C-09 | oneClickSubscribeHandlerでワンクリック購読 | E-01 (L226-248) | ○ |
| C-10 | 購読成功時に「Verification link sent」を表示 | E-01 (L270) | ○ |
| C-11 | 購読失敗時にサインアップページへ遷移 | E-01 (L237-245) | ○ |
| C-12 | pageData.signupで表示メッセージが変わる | E-01 (L326, L336-337) | ○ |
| C-13 | recommendations APIはlimit: 100で呼び出される | E-01 (L289), E-04 (L121) | ○ |
| C-14 | 機能No.60 サイトレコメンデーションが主機能 | E-05 (L143) | ○ |
| C-15 | 機能No.71 Portalが補助機能 | E-05 (L144) | ○ |
| C-16 | outbound_link_taggingでrefパラメータ付与 | E-01 (L196-214) | ○ |
| C-17 | Maybe laterボタンはsignup時のみ表示 | E-01 (L366-368) | ○ |
| C-18 | recommendation_clicksテーブルに記録 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **データベーステーブル名**：Beacon APIで送信されることはコード上確認できるが、実際のテーブル名はバックエンドのスキーマ定義を確認する必要がある
  - 候補：`ghost/core/core/server/data/schema/` / バックエンドAPIルーティング / データベースマイグレーション

## 5) リスクフラグ（レビュー観点）
- 0: データベース更新仕様のテーブル名は推測に基づいている（低リスク：機能的影響なし、ドキュメント精度の問題）

## 6) レビュアーチェックリスト（最小）
- [ ] データベーステーブル名（recommendation_clicks, recommendation_subscribes）がバックエンド実装と一致するか確認
- [ ] Beacon APIのエンドポイント `/members/api/recommendations/{id}/clicked` の存在確認
