---
generated_at: 2026-01-29 21:18:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：92-ローディングページ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `apps/portal/src/components/pages/loading-page.js` (1-15行目)
- E-02: `apps/portal/src/pages.js` (5行目、34行目)
- E-03: `apps/portal/src/App.js` (56行目、767行目、807-809行目)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (145行目)
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` (93行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LoadingPageはReactクラスコンポーネントである | E-01 (L4) | ○ |
| C-02 | LoaderIconをインポートして使用 | E-01 (L2) | ○ |
| C-03 | data-testid="loaderIcon"が付与されている | E-01 (L9) | ○ |
| C-04 | pagesマッピングでloading: LoadingPageと定義 | E-02 (L5, L34) | ○ |
| C-05 | 初期状態でpage: 'loading'が設定される | E-03 (L56) | ○ |
| C-06 | オファー処理開始時にloadingページを表示 | E-03 (L767) | ○ |
| C-07 | サインアップ処理開始時にloadingページを表示 | E-03 (L807-809) | ○ |
| C-08 | 機能No.71 Portalが主機能 | E-04 (L145) | ○ |
| C-09 | スタイルクラス名はgh-portal-loadingiconとdark | E-01 (L9) | ○ |
| C-10 | コンポーネントは15行未満のシンプルな実装 | E-01 (1-15行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] CSSアニメーション（gh-portal-loadingicon）の定義がapp.cssに存在するか確認
- [ ] loader.svgファイルの存在確認
