---
generated_at: 2026-01-29 21:22:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：93-コメント一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `apps/comments-ui/src/components/content/content.tsx` (1-189行目)
- E-02: `apps/comments-ui/src/app-context.ts` (1-133行目)
- E-03: `apps/comments-ui/src/components/content/forms/main-form.tsx` (1-111行目)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (146-147行目)
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` (94行目)
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` (337-377行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ContentコンポーネントがメインのUIを提供 | E-01, E-05 | ○ |
| C-02 | Comment型はid, html, member, replies等を持つ | E-02 (L16-33) | ○ |
| C-03 | useAppContextでコンテキストを取得 | E-01 (L76), E-02 (L114) | ○ |
| C-04 | isMemberでログイン状態を判定 | E-01 (L76, L145) | ○ |
| C-05 | hasRequiredTierでティア要件を判定 | E-01 (L76, L145) | ○ |
| C-06 | isCommentingDisabledでコメント無効を判定 | E-01 (L76, L145, L149) | ○ |
| C-07 | canCommentでMainForm表示を判定 | E-01 (L145, L148) | ○ |
| C-08 | showCtaBoxで未ログイン時CTAを表示 | E-01 (L150, L164-168) | ○ |
| C-09 | comments.mapでコメントコンポーネント生成 | E-01 (L152) | ○ |
| C-10 | SortingFormでソート順を選択 | E-01 (L170-176) | ○ |
| C-11 | Paginationコンポーネントでページネーション | E-01 (L180) | ○ |
| C-12 | commentIdToScrollToで特定コメントへスクロール | E-01 (L76, L123-142) | ○ |
| C-13 | labs.commentPermalinksでパーマリンク機能制御 | E-01 (L104, L121) | ○ |
| C-14 | dispatchActionでアクション実行 | E-01 (L81-83), E-02 (L104) | ○ |
| C-15 | 機能No.25 記事コメントが主機能 | E-04 (L146) | ○ |
| C-16 | 機能No.72 Comments UIが補助機能 | E-04 (L147) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] Comment型の全フィールドがAPIレスポンスと一致するか確認
- [ ] ソート順オプション（best/newest/oldest）がバックエンドと一致するか確認
- [ ] labs.commentPermalinks機能の有効化条件を確認
