---
generated_at: 2026-01-29 21:26:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：94-コメント投稿フォーム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `apps/comments-ui/src/components/content/forms/main-form.tsx` (1-111行目)
- E-02: `apps/comments-ui/src/components/content/forms/form.tsx` (1-395行目)
- E-03: `apps/comments-ui/src/app-context.ts` (44-48行目)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (148-149行目)
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` (95行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MainFormコンポーネントが新規コメント投稿を担当 | E-01, E-05 | ○ |
| C-02 | commentsCountでプレースホルダーを切り替え | E-01 (L14-17) | ○ |
| C-03 | useEditorフックでTiptapエディタを取得 | E-01 (L19) | ○ |
| C-04 | submit関数でaddCommentアクションを実行 | E-01 (L21-30) | ○ |
| C-05 | post_id, status, htmlを送信 | E-01 (L23-27), E-03 (L44-48) | ○ |
| C-06 | キーボードショートカット「C」でフォーカス | E-01 (L35-82) | ○ |
| C-07 | editor.isFocusedでフォーカス状態を判定 | E-01 (L65) | ○ |
| C-08 | scrollToElementでフォームにスクロール | E-01 (L68-70) | ○ |
| C-09 | FormWrapperでフォーム全体をラップ | E-01 (L98), E-02 (L299-391) | ○ |
| C-10 | Formコンポーネントでエディタを含む | E-01 (L99-104), E-02 (L228-289) | ○ |
| C-11 | submitSize='large'を設定 | E-01 (L90) | ○ |
| C-12 | submitText切り替え（PC: Add comment / モバイル: Comment） | E-01 (L85-89) | ○ |
| C-13 | editor.commands.clearContent()で送信後クリア | E-01 (L29) | ○ |
| C-14 | 機能No.25 記事コメントが主機能 | E-04 (L148) | ○ |
| C-15 | 機能No.72 Comments UIが補助機能 | E-04 (L149) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] addCommentアクションの実装がactions.tsに存在するか確認
- [ ] useEditorフックの実装がhooks.tsに存在するか確認
- [ ] Tiptapエディタの設定（拡張機能等）を確認
