---
generated_at: 2026-01-29 21:30:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：95-返信フォーム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `apps/comments-ui/src/components/content/forms/reply-form.tsx` (1-66行目)
- E-02: `apps/comments-ui/src/components/content/forms/form.tsx` (207-212行目)
- E-03: `apps/comments-ui/src/app-context.ts` (35-42行目)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (150-151行目)
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` (96行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ReplyFormがコメントへの返信を担当 | E-01, E-05 | ○ |
| C-02 | Props型はopenFormとparentを持つ | E-01 (L8-11) | ○ |
| C-03 | プレースホルダーは"Reply to comment" | E-01 (L18) | ○ |
| C-04 | autofocus: trueでオートフォーカス | E-01 (L19) | ○ |
| C-05 | submit関数でaddReplyアクションを実行 | E-01 (L24-35) | ○ |
| C-06 | close関数でcloseCommentFormアクションを実行 | E-01 (L37-39) | ○ |
| C-07 | submitTextはPC: Add reply / モバイル: Reply | E-01 (L41-43) | ○ |
| C-08 | useRefCallbackでスクロール処理 | E-01 (L15) | ○ |
| C-09 | isMobile()でreducedモード判定 | E-01 (L48, L54) | ○ |
| C-10 | FormWrapperでopenFormを渡す | E-01 (L48) | ○ |
| C-11 | OpenCommentForm型にin_reply_to_snippetがある | E-03 (L39) | ○ |
| C-12 | FormHeaderで返信先スニペット表示 | E-02 (L207-212) | ○ |
| C-13 | 機能No.25 記事コメントが主機能 | E-04 (L150) | ○ |
| C-14 | 機能No.72 Comments UIが補助機能 | E-04 (L151) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] addReplyアクションの実装がactions.tsに存在するか確認
- [ ] parent_idとin_reply_to_idの違いを理解しているか確認
- [ ] ネストされた返信の表示ロジックをcomment.tsxで確認
