---
generated_at: 2026-01-29 21:42:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：98-通報ポップアップ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **データベーステーブル名**：推測に基づく記載

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `apps/comments-ui/src/components/popups/report-popup.tsx` (1-91行目)
- E-02: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (156-157行目)
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` (99行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ReportPopupが通報を担当 | E-01, E-03 | ○ |
| C-02 | commentをPropsで受け取る | E-01 (L8) | ○ |
| C-03 | progressで状態管理（default/sending/sent） | E-01 (L10) | ○ |
| C-04 | ボタン色がdefault: bg-red-600, sent: bg-green-600 | E-01 (L12-15) | ○ |
| C-05 | ボタンテキスト切り替え（Report/Sending/Sent） | E-01 (L17-24) | ○ |
| C-06 | SpinnerIcon, SuccessIconをアイコンとして使用 | E-01 (L26-34) | ○ |
| C-07 | stopPropagationでイベント伝播を防止 | E-01 (L36-38) | ○ |
| C-08 | close関数でclosePopupアクション | E-01 (L40-42) | ○ |
| C-09 | submit関数で通報処理フロー | E-01 (L44-58) | ○ |
| C-10 | 1000ms後にsetProgress('sent')とreportComment | E-01 (L50-52) | ○ |
| C-11 | 750ms後にclose()を呼び出し | E-01 (L54-56) | ○ |
| C-12 | タイトルは"Report this comment?" | E-01 (L64) | ○ |
| C-13 | 説明メッセージ"Your request will be sent to the owner of this site." | E-01 (L66) | ○ |
| C-14 | comment_reportsテーブルに記録 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **データベーステーブル名**：reportCommentアクションでAPIが呼び出されることは確認できるが、実際のテーブル名はバックエンドを確認する必要がある
  - 候補：`ghost/core/core/server/data/schema/` / コメント関連のサービス

## 5) リスクフラグ（レビュー観点）
- 0: データベース更新仕様のテーブル名は推測に基づいている（低リスク：機能的影響なし）

## 6) レビュアーチェックリスト（最小）
- [ ] reportCommentアクションの実装がactions.tsに存在するか確認
- [ ] 通報APIのエンドポイント形式をバックエンドで確認
- [ ] 通報後の運営者への通知フローを確認
