---
generated_at: 2026-01-29 12:00:00
metrics:
  claims_total: 75
  claims_with_evidence: 75
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：結合テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された結合テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：75 / 75、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースがソースコードに基づいて抽出されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/test/e2e-api/admin/posts.test.js` - Posts Admin API E2Eテスト
- E-02: `ghost/core/test/e2e-api/admin/authentication.test.js` - Authentication Admin API E2Eテスト
- E-03: `ghost/core/test/e2e-api/admin/newsletters.test.js` - Newsletters Admin API E2Eテスト
- E-04: `ghost/core/test/e2e-api/admin/tags.test.js` - Tags Admin API E2Eテスト
- E-05: `ghost/core/test/e2e-api/admin/users.test.js` - Users Admin API E2Eテスト
- E-06: `ghost/core/test/e2e-api/members/signin.test.js` - Members Signin API E2Eテスト
- E-07: `ghost/core/test/e2e-api/members/webhooks.test.js` - Members Webhooks API E2Eテスト
- E-08: `ghost/core/test/e2e-api/content/posts.test.js` - Posts Content API E2Eテスト
- E-09: `ghost/core/test/integration/settings/settings.test.js` - Settings統合テスト
- E-10: `ghost/core/test/integration/url-service.test.js` - URL Service統合テスト
- E-11: `ghost/core/test/integration/services/mailgun-email-suppression-list.test.js` - Mailgun連携統合テスト
- E-12: `ghost/core/test/integration/services/email-service/batch-sending.test.js` - Email Batch Sending統合テスト

## 3) Claims と根拠の対応（レビューの主戦場）

### Posts API テスト（IT-001 〜 IT-014）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IT-001: 投稿一覧取得 - GET /posts/?limit=2 でステータス200 | E-01 | ○ |
| C-02 | IT-002: 投稿フォーマット指定取得 - formats パラメータ対応 | E-01 | ○ |
| C-03 | IT-003: 投稿エクスポート - CSV形式でエクスポート | E-01 | ○ |
| C-04 | IT-004: Mobiledocで投稿作成 - ステータス201 | E-01 | ○ |
| C-05 | IT-005: Lexicalで投稿作成 - リビジョン作成含む | E-01 | ○ |
| C-06 | IT-006: HTMLで投稿作成 - source=html パラメータ | E-01 | ○ |
| C-07 | IT-007: Mobiledoc/Lexical両方指定でエラー422 | E-01 | ○ |
| C-08 | IT-008: 不正なLexical形式でエラー422 | E-01 | ○ |
| C-09 | IT-009: 投稿更新（Mobiledoc）- リビジョン作成 | E-01 | ○ |
| C-10 | IT-010: 投稿更新（Lexical）- save_revision対応 | E-01 | ○ |
| C-11 | IT-011: 投稿削除 - ステータス204 | E-01 | ○ |
| C-12 | IT-012: 存在しない投稿削除でエラー404 | E-01 | ○ |
| C-13 | IT-013: 投稿コピー - copy エンドポイント | E-01 | ○ |
| C-14 | IT-014: MobiledocからLexical変換 | E-01 | ○ |

### Authentication API テスト（IT-015 〜 IT-016）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | IT-015: パスワードリセットトークン生成エラー | E-02 | ○ |
| C-16 | IT-016: パスワードリセット後2FAバイパス | E-02 | ○ |

### Newsletters API テスト（IT-017 〜 IT-023）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | IT-017: ニュースレター一覧取得 | E-03 | ○ |
| C-18 | IT-018: ニュースレター詳細取得 | E-03 | ○ |
| C-19 | IT-019: ニュースレター作成 | E-03 | ○ |
| C-20 | IT-020: ニュースレター作成（既存メンバー購読） | E-03 | ○ |
| C-21 | IT-021: ニュースレター編集 | E-03 | ○ |
| C-22 | IT-022: 重複名ニュースレター作成エラー | E-03 | ○ |
| C-23 | IT-023: ニュースレター数制限エラー | E-03 | ○ |

### Tags API テスト（IT-024 〜 IT-031）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | IT-024: タグ一覧取得 | E-04 | ○ |
| C-25 | IT-025: タグページネーション | E-04 | ○ |
| C-26 | IT-026: タグ詳細取得 | E-04 | ○ |
| C-27 | IT-027: タグ作成 | E-04 | ○ |
| C-28 | IT-028: 内部タグ作成 | E-04 | ○ |
| C-29 | IT-029: タグ編集 | E-04 | ○ |
| C-30 | IT-030: タグ削除 | E-04 | ○ |
| C-31 | IT-031: 存在しないタグ削除エラー | E-04 | ○ |

### Users API テスト（IT-032 〜 IT-038）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | IT-032: ユーザー一覧取得 | E-05 | ○ |
| C-33 | IT-033: ユーザーロール含む取得 | E-05 | ○ |
| C-34 | IT-034: ユーザーページネーション | E-05 | ○ |
| C-35 | IT-035: ユーザーID検索 | E-05 | ○ |
| C-36 | IT-036: ユーザースラッグ検索 | E-05 | ○ |
| C-37 | IT-037: ユーザーメール検索 | E-05 | ○ |
| C-38 | IT-038: ユーザー編集 | E-05 | ○ |

### Members Signin API テスト（IT-039 〜 IT-047）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | IT-039: 無効なトークンでサインイン失敗 | E-06 | ○ |
| C-40 | IT-040: 有効なトークンでサインイン成功 | E-06 | ○ |
| C-41 | IT-041: サインアップ時ウェルカムページリダイレクト | E-06 | ○ |
| C-42 | IT-042: 有料サインアップ時リダイレクト | E-06 | ○ |
| C-43 | IT-043: 新規メンバー作成 | E-06 | ○ |
| C-44 | IT-044: サインインでメンバー非作成 | E-06 | ○ |
| C-45 | IT-045: UTMパラメータ保存 | E-06 | ○ |
| C-46 | IT-046: トークン10分後期限切れ | E-06 | ○ |
| C-47 | IT-047: トークン3回使用後期限切れ | E-06 | ○ |

### Stripe Webhooks テスト（IT-048 〜 IT-049）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | IT-048: 無効な署名で401 | E-07 | ○ |
| C-49 | IT-049: 未知イベントで200 | E-07 | ○ |

### Content API Posts テスト（IT-050 〜 IT-053）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | IT-050: 投稿一覧取得（Content API） | E-08 | ○ |
| C-51 | IT-051: Mobiledoc/Lexicalフォーマット制限 | E-08 | ○ |
| C-52 | IT-052: タグでフィルタリング | E-08 | ○ |
| C-53 | IT-053: 著者でフィルタリング | E-08 | ○ |

### DB連携テスト（IT-054 〜 IT-057）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | IT-054: コア設定変更検出 | E-09 | ○ |
| C-55 | IT-055: デフォルトルーティングURL生成 | E-10 | ○ |
| C-56 | IT-056: カスタムルーティングURL生成 | E-10 | ○ |
| C-57 | IT-057: サブディレクトリURL生成 | E-10 | ○ |

### 外部サービス連携テスト（IT-058 〜 IT-061）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | IT-058: 永続的失敗イベント処理（605） | E-11 | ○ |
| C-59 | IT-059: 永続的失敗イベント処理（607） | E-11 | ○ |
| C-60 | IT-060: 永続的失敗イベント処理（4xx） | E-11 | ○ |
| C-61 | IT-061: 苦情イベント処理 | E-11 | ○ |

### コンポーネント連携テスト（IT-062 〜 IT-075）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | IT-062: スケジュール投稿メール送信 | E-12 | ○ |
| C-63 | IT-063: 有料/無料バッチ分割 | E-12 | ○ |
| C-64 | IT-064: 受信者フィルター適用 | E-12 | ○ |
| C-65 | IT-065: バッチサイズ分割 | E-12 | ○ |
| C-66 | IT-066: 失敗バッチリトライ | E-12 | ○ |
| C-67 | IT-067: メール検証要求時送信拒否 | E-12 | ○ |
| C-68 | IT-068: リンクトラッキング追加 | E-12 | ○ |
| C-69 | IT-069: リンククリック記録 | E-12 | ○ |
| C-70 | IT-070: 名前置換（名前なしメンバー） | E-12 | ○ |
| C-71 | IT-071: 名前置換（名前ありメンバー） | E-12 | ○ |
| C-72 | IT-072: 投稿タイトルセクション非表示 | E-12 | ○ |
| C-73 | IT-073: コメントボタン表示 | E-12 | ○ |
| C-74 | IT-074: 購読詳細ボックス表示 | E-12 | ○ |
| C-75 | IT-075: 最新投稿3件表示 | E-12 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - 全テストケースがソースコードの実際のテストファイルから抽出されています

**注意事項**:
- IT-062 〜 IT-075 のEmail Batch Sendingテストは現在 `describe.skip` でスキップされています
- これらのテストは順序依存性の問題により断続的に失敗するため、一時的に無効化されています
- テストケースとしての仕様は有効ですが、実行可能な状態ではありません

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに直接対応
- 注意点: Email Batch Sendingテスト（IT-062〜IT-075）はスキップ状態のため、実際のテスト実行時には動作しない

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースIDが一意であることを確認
- [ ] テスト種別の分類が適切であることを確認
- [ ] 前提条件と手順の記述が実行可能なレベルであることを確認
- [ ] 期待結果が検証可能であることを確認
- [ ] 優先度の設定が妥当であることを確認
- [ ] スキップ状態のテスト（IT-062〜IT-075）の取り扱いを検討
