---
generated_at: 2026-01-29 14:30:00
metrics:
  claims_total: 53
  claims_with_evidence: 53
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：通知一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：53 / 53、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張にソースコードの根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/services/members/emails/signin.js`
- E-02: `ghost/core/core/server/services/members/emails/signup.js`
- E-03: `ghost/core/core/server/services/members/emails/signup-paid.js`
- E-04: `ghost/core/core/server/services/members/emails/subscribe.js`
- E-05: `ghost/core/core/server/services/members/emails/update-email.js`
- E-06: `ghost/core/core/server/services/member-welcome-emails/service.js`
- E-07: `ghost/core/core/server/services/email-service/email-service.js`
- E-08: `ghost/core/core/server/services/comments/comments-service-emails.js`
- E-09: `ghost/core/core/server/services/staff/staff-service-emails.js`
- E-10: `ghost/core/core/server/services/staff/staff-service.js`
- E-11: `ghost/core/core/server/services/mentions-email-report/service.js`
- E-12: `ghost/core/core/server/services/recommendations/service/incoming-recommendation-email-renderer.ts`
- E-13: `ghost/core/core/server/services/invites/invites.js`
- E-14: `ghost/core/core/server/services/auth/passwordreset.js`
- E-15: `ghost/core/core/server/services/newsletters/emails/verify-email.js`
- E-16: `ghost/core/core/server/services/update-check/update-check-service.js`
- E-17: `ghost/core/core/server/services/notifications/notifications.js`
- E-18: `ghost/core/core/server/services/slack.js`
- E-19: `ghost/core/core/server/services/slack-notifications/slack-notifications.js`
- E-20: `ghost/core/core/server/services/webhooks/listen.js`
- E-21: `ghost/core/core/server/services/webhooks/webhook-trigger.js`
- E-22: `ghost/core/core/server/services/webhooks/webhooks-service.js`
- E-23: `ghost/core/core/server/services/mail/ghost-mailer.js`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 会員サインインメール | E-01 | ○ |
| C-02 | 会員サインアップメール | E-02 | ○ |
| C-03 | 有料会員登録完了メール | E-03 | ○ |
| C-04 | 購読確認メール | E-04 | ○ |
| C-05 | メールアドレス変更確認メール | E-05 | ○ |
| C-06 | 会員ウェルカムメール | E-06 | ○ |
| C-07 | ニュースレターメール | E-07 | ○ |
| C-08 | 新規コメント通知 | E-08 | ○ |
| C-09 | コメント返信通知 | E-08 | ○ |
| C-10 | コメント報告通知 | E-08 | ○ |
| C-11 | 無料会員サインアップ通知 | E-09, E-10 | ○ |
| C-12 | 有料サブスクリプション開始通知 | E-09, E-10 | ○ |
| C-13 | サブスクリプションキャンセル通知 | E-09, E-10 | ○ |
| C-14 | マイルストーン達成通知 | E-09, E-10 | ○ |
| C-15 | ドネーション受領通知 | E-09 | ○ |
| C-16 | メンションレポート | E-11 | ○ |
| C-17 | レコメンデーション受信通知 | E-12 | ○ |
| C-18 | スタッフ招待メール | E-13 | ○ |
| C-19 | パスワードリセットメール | E-14 | ○ |
| C-20 | ニュースレターメールアドレス検証 | E-15 | ○ |
| C-21 | アップデートチェック重要アラート | E-16 | ○ |
| C-22 | システム通知 | E-17 | ○ |
| C-23 | 投稿公開Slack通知 | E-18 | ○ |
| C-24 | マイルストーンSlack通知 | E-19 | ○ |
| C-25 | post.added Webhook | E-20 | ○ |
| C-26 | post.deleted Webhook | E-20 | ○ |
| C-27 | post.edited Webhook | E-20 | ○ |
| C-28 | post.published Webhook | E-20 | ○ |
| C-29 | post.published.edited Webhook | E-20 | ○ |
| C-30 | post.unpublished Webhook | E-20 | ○ |
| C-31 | post.scheduled Webhook | E-20 | ○ |
| C-32 | post.unscheduled Webhook | E-20 | ○ |
| C-33 | post.rescheduled Webhook | E-20 | ○ |
| C-34 | page.added Webhook | E-20 | ○ |
| C-35 | page.deleted Webhook | E-20 | ○ |
| C-36 | page.edited Webhook | E-20 | ○ |
| C-37 | page.published Webhook | E-20 | ○ |
| C-38 | page.published.edited Webhook | E-20 | ○ |
| C-39 | page.unpublished Webhook | E-20 | ○ |
| C-40 | page.scheduled Webhook | E-20 | ○ |
| C-41 | page.unscheduled Webhook | E-20 | ○ |
| C-42 | page.rescheduled Webhook | E-20 | ○ |
| C-43 | tag.added Webhook | E-20 | ○ |
| C-44 | tag.edited Webhook | E-20 | ○ |
| C-45 | tag.deleted Webhook | E-20 | ○ |
| C-46 | member.added Webhook | E-20 | ○ |
| C-47 | member.deleted Webhook | E-20 | ○ |
| C-48 | member.edited Webhook | E-20 | ○ |
| C-49 | post.tag.attached Webhook | E-20 | ○ |
| C-50 | post.tag.detached Webhook | E-20 | ○ |
| C-51 | page.tag.attached Webhook | E-20 | ○ |
| C-52 | page.tag.detached Webhook | E-20 | ○ |
| C-53 | site.changed Webhook | E-20 | ○ |

## 4) 不足情報（Unknown / Missing）
- 現時点で根拠なしの主張はありません。すべての通知機能はソースコードから直接確認されています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての通知機能がソースコードで確認されており、信頼度は高い

## 6) レビュアーチェックリスト（最小）
- [ ] 通知カテゴリの分類が適切か確認
- [ ] 各通知の説明がソースコードの実装と一致しているか確認
- [ ] Webhookイベント一覧が最新のコードベースと一致しているか確認
- [ ] スタッフ向けメール通知の設定オプション（email alert users）が正しく記載されているか確認
- [ ] メール送信に使用されるテンプレートファイル（.hbs, .txt.js）が存在することを確認
