# 通知設計書 26-post.deleted

## 概要

本ドキュメントは、Ghost CMSにおける投稿削除時のWebhook通知（`post.deleted`イベント）の設計仕様を記載する。

### 本通知の処理概要

投稿（Post）が削除された際にトリガーされるWebhook通知である。外部システムとの連携において、コンテンツの削除を通知し、検索インデックスの更新、キャッシュの無効化、バックアップシステムへの通知などを実現する。

**業務上の目的・背景**：コンテンツ管理において、削除されたコンテンツの情報を外部システムに伝達することは重要である。検索エンジンからの削除、CDNキャッシュの無効化、関連システムでのリンク切れ対応など、投稿削除に伴う各種クリーンアップ処理を自動化できる。

**通知の送信タイミング**：投稿モデル（Post）で`onDestroyed`イベントが発火し、`post.deleted`イベントが発行された時点で、登録されているすべてのWebhookに対してHTTPリクエストが送信される。

**通知の受信者**：Ghost管理画面のIntegration設定でこのイベントに対して登録されたWebhookエンドポイント。

**通知内容の概要**：削除された投稿の識別情報（ID等）が含まれる。削除後のため詳細データは空となる場合がある。

**期待されるアクション**：Webhook受信側システムは、投稿IDを基に関連データの削除、インデックスからの除去、キャッシュ無効化などを実行する。

## 通知種別

Webhook（HTTP POST）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（イベントリスナー経由） |
| 優先度 | 中 |
| リトライ | 5回（テスト環境では0回） |

### 送信先決定ロジック

1. `webhooks`テーブルから`event = 'post.deleted'`のレコードを全件取得
2. `customIntegrations`プラン制限が有効な場合、`internal`タイプのIntegrationに紐づくWebhookのみ対象
3. 各Webhookの`target_url`に対してHTTPリクエストを送信

## 通知テンプレート

### Webhook通知の場合

| 項目 | 内容 |
|-----|------|
| HTTPメソッド | POST |
| Content-Type | `application/json` |
| Content-Version | `v{ghostVersion.safe}` |
| タイムアウト | 2000ms |

### ペイロード構造

```json
{
    "post": {
        "current": {},
        "previous": {
            "id": "5ddc9141c35e7700383b2937",
            "uuid": "a5aa9bd8-ea31-415c-b452-3040dae1e730",
            "title": "Deleted Post Title",
            "slug": "deleted-post-title"
        }
    }
}
```

**注意**: `post.deleted`イベントでは、`current`は空オブジェクトとなり、`previous`に削除前の属性のうち変更されたフィールドが含まれる。

### 署名ヘッダー（オプション）

Webhookに`secret`が設定されている場合：

```
X-Ghost-Signature: sha256={HMAC-SHA256(payload + timestamp)}, t={timestamp}
```

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| post.current | 現在の投稿データ（削除後は空） | 空オブジェクト | Yes |
| post.previous | 削除前のデータ（変更フィールドのみ） | Postモデル._previousAttributes | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| モデルイベント | `post.deleted` | Webhookが登録されている | 投稿削除時に自動送信 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| Webhook未登録 | このイベントに対するWebhookが1件も登録されていない場合 |
| インポート時 | `options.importing === true`の場合は送信しない |
| プラン制限 | `customIntegrations`制限時、internalタイプ以外のIntegrationのWebhookは除外 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Post.onDestroyed発火] --> B{importingフラグ?}
    B -->|true| C[終了]
    B -->|false| D[events.emit post.deleted]
    D --> E[WebhookTrigger.trigger]
    E --> F[getAll - Webhook取得]
    F --> G{Webhook数確認}
    G -->|0件| C
    G -->|1件以上| H[payloadシリアライズ]
    H --> I[各Webhookにループ]
    I --> J[HTTPリクエスト送信]
    J --> K{送信結果}
    K -->|成功| L[onSuccess]
    K -->|410| M[Webhook削除]
    K -->|エラー| N[onError]
    L --> O{次のWebhook}
    M --> O
    N --> O
    O -->|あり| I
    O -->|なし| C
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| webhooks | 登録Webhook取得 | `event = 'post.deleted'`でフィルタ |
| integrations | Integration情報 | プラン制限時の判定用 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| webhooks | UPDATE | 送信結果の記録 |
| webhooks | DELETE | 410レスポンス時の自動削除 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 410 Gone | Webhookエンドポイントが410を返した | Webhook自動削除 |
| タイムアウト | 2000ms以内にレスポンスなし | エラー記録、リトライ |
| ネットワークエラー | 接続失敗 | エラー記録、リトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 5回（本番）、0回（テスト環境） |
| リトライ間隔 | @tryghost/requestライブラリのデフォルト |
| リトライ対象エラー | タイムアウト、ネットワークエラー、5xxエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし（イベント発生時に即時送信）

## セキュリティ考慮事項

- Webhook URLはIntegration管理者のみが設定可能
- `secret`設定時はHMAC-SHA256署名をヘッダーに付与
- 削除された投稿の詳細情報は最小限のみ送信

## 備考

- 削除イベントでは`current`が空になるため、投稿の識別には`previous`フィールドを使用する必要がある
- 完全削除（hard delete）の場合、`_previousAttributes`から取得可能なデータのみが含まれる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: イベント定義を確認する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | listen.js | `ghost/core/core/server/services/webhooks/listen.js` | 14行目、`post.deleted`イベント定義 |

#### Step 2: シリアライズ処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | serialize.js | `ghost/core/core/server/services/webhooks/serialize.js` | 43-64行目、previousAttributes処理 |

**読解のコツ**: 削除イベントでは`model.attributes`が空になるため、37-41行目の分岐で空オブジェクトが返される。一方、`_previousAttributes`から変更前データが取得される。

#### Step 3: Webhook送信処理（共通）

No.25「post.added」と同じ処理フローを参照。

### プログラム呼び出し階層図

```
Post.onDestroyed
    │
    └─ events.emit('post.deleted')
           │
           └─ processWebhookTrigger(model, options)
                  │
                  └─ webhookTrigger.trigger('post.deleted', model)
                         │
                         ├─ getAll('post.deleted')
                         │
                         ├─ payload(event, model)
                         │      └─ serialize(event, model)
                         │             └─ current: {}, previous: {...}
                         │
                         └─ request(url, opts)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| listen.js | `ghost/core/core/server/services/webhooks/listen.js` | ソース | イベントリスナー登録 |
| webhook-trigger.js | `ghost/core/core/server/services/webhooks/webhook-trigger.js` | ソース | Webhook送信ロジック |
| serialize.js | `ghost/core/core/server/services/webhooks/serialize.js` | ソース | ペイロードシリアライズ |
