# 通知設計書 27-post.edited

## 概要

本ドキュメントは、Ghost CMSにおける投稿編集時のWebhook通知（`post.edited`イベント）の設計仕様を記載する。

### 本通知の処理概要

投稿（Post）が編集された際にトリガーされるWebhook通知である。タイトル、本文、メタデータなどの変更を外部システムに通知し、検索インデックスの更新、キャッシュの無効化、翻訳システムへの通知などを実現する。

**業務上の目的・背景**：コンテンツ管理において、投稿の更新情報を外部システムにリアルタイムで伝達することは重要である。検索エンジンのインデックス更新、CDNキャッシュのパージ、翻訳サービスへの変更通知、分析ツールへのコンテンツ更新通知など、様々な自動化ワークフローを構築できる。

**通知の送信タイミング**：投稿モデル（Post）で`onUpdated`イベントが発火し、`post.edited`イベントが発行された時点で、登録されているすべてのWebhookに対してHTTPリクエストが送信される。

**通知の受信者**：Ghost管理画面のIntegration設定でこのイベントに対して登録されたWebhookエンドポイント。

**通知内容の概要**：編集後の投稿データ（current）と、変更されたフィールドの編集前データ（previous）が含まれる。これにより差分検出が可能。

**期待されるアクション**：Webhook受信側システムは、current/previous差分を分析し、必要な処理（インデックス更新、キャッシュ無効化、通知転送など）を実行する。

## 通知種別

Webhook（HTTP POST）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（イベントリスナー経由） |
| 優先度 | 中 |
| リトライ | 5回（テスト環境では0回） |

### 送信先決定ロジック

1. `webhooks`テーブルから`event = 'post.edited'`のレコードを全件取得
2. `customIntegrations`プラン制限が有効な場合、`internal`タイプのIntegrationに紐づくWebhookのみ対象
3. 各Webhookの`target_url`に対してHTTPリクエストを送信

## 通知テンプレート

### Webhook通知の場合

| 項目 | 内容 |
|-----|------|
| HTTPメソッド | POST |
| Content-Type | `application/json` |
| Content-Version | `v{ghostVersion.safe}` |
| タイムアウト | 2000ms |

### ペイロード構造

```json
{
    "post": {
        "current": {
            "id": "5ddc9141c35e7700383b2937",
            "uuid": "a5aa9bd8-ea31-415c-b452-3040dae1e730",
            "title": "Updated Post Title",
            "slug": "post-title",
            "html": "<p>Updated content...</p>",
            "plaintext": "Updated content...",
            "status": "draft",
            "updated_at": "2024-01-02T00:00:00.000Z",
            "tags": [...],
            "authors": [...]
        },
        "previous": {
            "title": "Original Post Title",
            "html": "<p>Original content...</p>",
            "updated_at": "2024-01-01T00:00:00.000Z"
        }
    }
}
```

**注意**: `previous`には変更されたフィールドのみが含まれる（`_changed`キーで判定）。

### 署名ヘッダー（オプション）

Webhookに`secret`が設定されている場合：

```
X-Ghost-Signature: sha256={HMAC-SHA256(payload + timestamp)}, t={timestamp}
```

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| post.current | 編集後の投稿データ | Postモデル（シリアライズ済み） | Yes |
| post.previous | 変更前データ（変更フィールドのみ） | Postモデル._previousAttributes | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| モデルイベント | `post.edited` | Webhookが登録されている | 投稿更新時に自動送信 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| Webhook未登録 | このイベントに対するWebhookが1件も登録されていない場合 |
| インポート時 | `options.importing === true`の場合は送信しない |
| プラン制限 | `customIntegrations`制限時、internalタイプ以外のIntegrationのWebhookは除外 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Post.onUpdated発火] --> B{importingフラグ?}
    B -->|true| C[終了]
    B -->|false| D[events.emit post.edited]
    D --> E[WebhookTrigger.trigger]
    E --> F[getAll - Webhook取得]
    F --> G{Webhook数確認}
    G -->|0件| C
    G -->|1件以上| H[payloadシリアライズ]
    H --> I[_changedから変更フィールド特定]
    I --> J[current/previous構築]
    J --> K[各Webhookにループ]
    K --> L[HTTPリクエスト送信]
    L --> M{送信結果}
    M -->|成功| N[onSuccess]
    M -->|410| O[Webhook削除]
    M -->|エラー| P[onError]
    N --> Q{次のWebhook}
    O --> Q
    P --> Q
    Q -->|あり| K
    Q -->|なし| C
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| webhooks | 登録Webhook取得 | `event = 'post.edited'`でフィルタ |
| integrations | Integration情報 | プラン制限時の判定用 |
| posts | 投稿データ | イベント引数から取得 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| webhooks | UPDATE | 送信結果の記録 |
| webhooks | DELETE | 410レスポンス時の自動削除 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 410 Gone | Webhookエンドポイントが410を返した | Webhook自動削除 |
| タイムアウト | 2000ms以内にレスポンスなし | エラー記録、リトライ |
| ネットワークエラー | 接続失敗 | エラー記録、リトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 5回（本番）、0回（テスト環境） |
| リトライ間隔 | @tryghost/requestライブラリのデフォルト |
| リトライ対象エラー | タイムアウト、ネットワークエラー、5xxエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし（イベント発生時に即時送信）

## セキュリティ考慮事項

- Webhook URLはIntegration管理者のみが設定可能
- `secret`設定時はHMAC-SHA256署名をヘッダーに付与
- 投稿データにはタグ、著者情報が含まれる

## 備考

- `previous`には`_changed`で追跡された変更フィールドのみが含まれる
- 自動保存による頻繁な編集イベントが発生する可能性があるため、受信側でデバウンス処理を推奨
- `post.published.edited`とは異なり、公開状態に関係なく発火する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: イベント定義を確認する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | listen.js | `ghost/core/core/server/services/webhooks/listen.js` | 15行目、`post.edited`イベント定義 |

#### Step 2: シリアライズ処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | serialize.js | `ghost/core/core/server/services/webhooks/serialize.js` | 66-81行目、current/previous構築 |

**読解のコツ**:
- 71行目の`model._changed`から変更されたフィールド名を取得
- 76行目の`_.pick(previous, changed)`で変更フィールドのみを抽出

#### Step 3: Webhook送信処理（共通）

No.25「post.added」と同じ処理フローを参照。

### プログラム呼び出し階層図

```
Post.onUpdated
    │
    └─ events.emit('post.edited')
           │
           └─ processWebhookTrigger(model, options)
                  │
                  └─ webhookTrigger.trigger('post.edited', model)
                         │
                         ├─ getAll('post.edited')
                         │
                         ├─ payload(event, model)
                         │      └─ serialize(event, model)
                         │             ├─ current: シリアライズ済みデータ
                         │             └─ previous: _.pick(prev, _changed)
                         │
                         └─ request(url, opts)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| listen.js | `ghost/core/core/server/services/webhooks/listen.js` | ソース | イベントリスナー登録 |
| webhook-trigger.js | `ghost/core/core/server/services/webhooks/webhook-trigger.js` | ソース | Webhook送信ロジック |
| serialize.js | `ghost/core/core/server/services/webhooks/serialize.js` | ソース | ペイロードシリアライズ |
