# 通知設計書 31-post.scheduled

## 概要

本ドキュメントは、Ghost CMSにおける `post.scheduled` Webhookイベントの設計仕様を定義する。このWebhookは投稿がスケジュール公開に設定された際にトリガーされる。

### 本通知の処理概要

**業務上の目的・背景**：コンテンツ管理システムにおいて、投稿のスケジュール公開は重要な機能である。外部システム（CI/CD、静的サイトジェネレーター、SNS自動投稿ツール、分析システムなど）がスケジュールされた投稿を事前に把握し、公開に備えた準備処理を行う必要がある。このWebhookにより、投稿がスケジュールされたタイミングで外部システムへリアルタイムに通知を送信し、自動化ワークフローを実現する。

**通知の送信タイミング**：投稿のステータスが `draft` や他の状態から `scheduled` に変更された際、または新規投稿が `scheduled` ステータスで作成された際にトリガーされる。具体的には、Postモデルの `onSaved`（新規作成時）または `onUpdated`（更新時）イベントハンドラ内で、ステータスが `scheduled` に変化したことを検知し、`post.scheduled` イベントを発火する。

**通知の受信者**：`webhooks` テーブルに登録されている `event = 'post.scheduled'` のWebhookエンドポイント全て。各Webhookは特定のIntegration（連携アプリケーション）に紐づいており、カスタムIntegration制限がある場合は内部Integrationのみに制限される。

**通知内容の概要**：投稿の現在の状態（`current`）と変更前の状態（`previous`）を含むJSONペイロード。投稿データには、タイトル、スラグ、HTML/プレーンテキストコンテンツ、公開予定日時、著者情報、タグ情報、ティア情報などが含まれる。

**期待されるアクション**：受信システムは、スケジュールされた投稿の情報を基に、公開予定日時に合わせた準備処理（プレビュー生成、SNS投稿予約、キャッシュウォームアップなど）を実行することが期待される。

## 通知種別

Webhook（HTTP POST リクエスト）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（イベント駆動） |
| 優先度 | 中 |
| リトライ | 有・5回（テスト環境では0回） |

### 送信先決定ロジック

1. `webhooks` テーブルから `event = 'post.scheduled'` に一致するレコードを取得
2. カスタムIntegration制限（`customIntegrations` limit）が有効な場合、`integration.type = 'internal'` のWebhookのみに絞り込み
3. 各Webhookの `target_url` に対してHTTP POSTリクエストを送信

## 通知テンプレート

### Webhook通知の場合

| 項目 | 内容 |
|-----|------|
| HTTPメソッド | POST |
| Content-Type | application/json |
| Content-Version | v{Ghost APIバージョン} |
| タイムアウト | 2000ms |

### ペイロード構造

```json
{
  "post": {
    "current": {
      "id": "投稿ID",
      "uuid": "UUID",
      "title": "投稿タイトル",
      "slug": "スラグ",
      "html": "HTMLコンテンツ",
      "plaintext": "プレーンテキスト",
      "status": "scheduled",
      "published_at": "公開予定日時（ISO8601形式）",
      "created_at": "作成日時",
      "updated_at": "更新日時",
      "url": "投稿URL",
      "authors": [...],
      "tags": [...],
      "tiers": [...],
      "primary_author": {...},
      "primary_tag": {...}
    },
    "previous": {
      "status": "変更前のステータス",
      "updated_at": "変更前の更新日時"
    }
  }
}
```

### 署名ヘッダー

Webhookに `secret` が設定されている場合、以下の形式で署名ヘッダーが付与される：

```
X-Ghost-Signature: sha256={HMAC-SHA256署名}, t={タイムスタンプ}
```

署名は `{ペイロードJSON}{タイムスタンプ}` を `secret` で HMAC-SHA256 ハッシュ化したもの。

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| post.current.id | 投稿ID | posts.id | Yes |
| post.current.uuid | 投稿UUID | posts.uuid | Yes |
| post.current.title | タイトル | posts.title | Yes |
| post.current.slug | スラグ | posts.slug | Yes |
| post.current.status | ステータス | posts.status | Yes |
| post.current.published_at | 公開予定日時 | posts.published_at | Yes |
| post.current.html | HTMLコンテンツ | posts.html | No |
| post.current.plaintext | プレーンテキスト | posts.plaintext | No |
| post.current.authors | 著者リスト | posts_authors + users | Yes |
| post.current.tags | タグリスト | posts_tags + tags | No |
| post.current.tiers | ティアリスト | posts_products + products | No |
| post.previous | 変更前の値 | モデル._previousAttributes | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作/API | Post作成（status=scheduled） | 新規投稿がscheduledステータスで作成 | Admin APIまたは管理画面から投稿を作成 |
| 画面操作/API | Post更新（status変更→scheduled） | ステータスがscheduledに変更 | 既存投稿のステータスをscheduledに変更 |
| 画面操作/API | リソースタイプ変更 | page→postの変換でscheduled状態 | ページから投稿への変換時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| options.importing = true | データインポート中は送信しない |
| webhooks テーブルに該当レコードなし | 登録されたWebhookがない場合 |
| customIntegrations制限超過 | 内部Integration以外のWebhookは無効化 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[投稿作成/更新] --> B{ステータス変更?}
    B -->|Yes| C{scheduled に変更?}
    B -->|No| D{既にscheduled?}
    C -->|Yes| E[post.scheduled イベント発火]
    C -->|No| Z[終了]
    D -->|Yes| F{published_at変更?}
    D -->|No| Z
    F -->|Yes| G[post.rescheduled イベント発火]
    F -->|No| Z
    E --> H[WebhookTrigger.trigger 呼び出し]
    H --> I[webhooks テーブル検索]
    I --> J{Webhook存在?}
    J -->|No| Z
    J -->|Yes| K[各Webhookにペイロード送信]
    K --> L{送信結果}
    L -->|成功| M[last_triggered_at/status更新]
    L -->|失敗| N{410 Gone?}
    N -->|Yes| O[Webhook削除]
    N -->|No| P[エラー記録・リトライ]
    M --> Z
    O --> Z
    P --> Z
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| posts | 投稿データ取得 | currentとpreviousの値を取得 |
| webhooks | Webhook設定取得 | event='post.scheduled'で検索 |
| integrations | Integration情報 | Webhook経由で関連取得 |
| users | 著者情報 | posts_authors経由 |
| tags | タグ情報 | posts_tags経由 |
| products | ティア情報 | posts_products経由 |

### テーブル別参照項目詳細

#### webhooks

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | Webhook識別 | event = 'post.scheduled' |
| event | イベント種別 | 検索条件 |
| target_url | 送信先URL | 必須 |
| secret | 署名用シークレット | オプション |
| integration_id | Integration紐付け | limit判定用 |

#### posts

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| 全カラム | ペイロード生成 | id指定 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| webhooks | UPDATE | 送信結果の記録 |

#### webhooks更新

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | last_triggered_at | Date.now() | 送信時刻 |
| UPDATE | last_triggered_status | HTTPステータスコード | 成功/失敗 |
| UPDATE | last_triggered_error | エラーメッセージ | 失敗時のみ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | ネットワークエラー、タイムアウト | リトライ実行、エラーログ記録 |
| 410 Gone | 送信先が恒久的に削除 | Webhookレコードを自動削除 |
| 4xx/5xx | サーバーエラー | ステータス記録、リトライ実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 5回（本番環境）、0回（テスト環境） |
| リトライ間隔 | @tryghost/requestライブラリのデフォルト設定に依存 |
| リトライ対象エラー | ネットワークエラー、一時的なサーバーエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（イベント発生ベース） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（イベント発生時に即座に送信）

## セキュリティ考慮事項

- Webhookに `secret` を設定することで、HMAC-SHA256署名による送信元検証が可能
- HTTPS URLの使用を推奨
- 署名検証により、受信側でリクエストの正当性を確認可能
- タイムスタンプを含むことでリプレイ攻撃を検知可能

## 備考

- `post.scheduled` は投稿が初めてスケジュールされた時にトリガー
- 既にスケジュール済みの投稿の公開日時を変更した場合は `post.rescheduled` がトリガー
- スケジュールを解除（draft等に戻す）した場合は `post.unscheduled` がトリガー
- 投稿タイプが `page` の場合は `page.scheduled` イベントがトリガーされる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Webhookシステムの基本データ構造と、投稿モデルのイベント発火の仕組みを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | schema.js | `ghost/core/core/server/data/schema/schema.js` | webhooksテーブル定義（353-370行目）、postsテーブル定義（61-105行目）を確認 |
| 1-2 | webhook.js | `ghost/core/core/server/models/webhook.js` | Webhookモデルの構造、findAllByEventメソッド（46-52行目） |

**読解のコツ**: Ghostはbookshelfをベースにしたモデル層を使用。`ghostBookshelf.Model.extend()`でモデル定義される。

#### Step 2: エントリーポイントを理解する

イベント発火の起点となるPostモデルを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | post.js | `ghost/core/core/server/models/post.js` | `onSaved`（378-392行目）と`onUpdated`（394-464行目）でscheduledイベント発火を確認 |

**主要処理フロー**:
1. **389-391行目**: 新規作成時、statusが'scheduled'なら`model.emitChange('scheduled')`を呼び出し
2. **439-441行目**: 更新時、statusが'scheduled'に変化したら`model.emitChange('scheduled')`を呼び出し
3. **356-367行目**: `emitChange`メソッドで`post.scheduled`イベントを発火

#### Step 3: Webhookリスナーを理解する

イベントを受けてWebhook送信を行う処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | listen.js | `ghost/core/core/server/services/webhooks/listen.js` | WEBHOOKS配列（10-45行目）、イベントリスナー登録（47-68行目） |

**主要処理フロー**:
- **19行目**: 'post.scheduled'がWEBHOOKS配列に含まれている
- **59-66行目**: イベントハンドラで`webhookTrigger.trigger(event, model)`を呼び出し

#### Step 4: Webhook送信処理を理解する

実際のHTTPリクエスト送信処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | webhook-trigger.js | `ghost/core/core/server/services/webhooks/webhook-trigger.js` | triggerメソッド（98-143行目）、署名生成（122-124行目） |
| 4-2 | payload.js | `ghost/core/core/server/services/webhooks/payload.js` | ペイロード生成処理 |
| 4-3 | serialize.js | `ghost/core/core/server/services/webhooks/serialize.js` | モデルのシリアライズ処理 |

**主要処理フロー**:
- **104行目**: `getAll(event)`でWebhookを取得
- **109行目**: `this.payload()`でペイロード生成
- **116-124行目**: HTTPヘッダー設定（署名含む）
- **139-141行目**: リクエスト送信と結果ハンドリング

### プログラム呼び出し階層図

```
Post.edit() / Post.add()
    │
    ├─ onSaved() / onUpdated()
    │      └─ emitChange('scheduled')
    │              └─ events.emit('post.scheduled', model)
    │
    └─ [イベントシステム]
           │
           └─ processWebhookTrigger(model, options)
                  └─ WebhookTrigger.trigger(event, model)
                         │
                         ├─ getAll(event)
                         │      └─ Webhook.findAllByEvent('post.scheduled')
                         │
                         ├─ payload(event, model)
                         │      └─ serialize(event, model)
                         │
                         └─ request(url, opts)
                                ├─ onSuccess() → update()
                                └─ onError() → update() / destroy()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

投稿データ(Post) ───▶ Postモデル
                      │ (status変更検知)
                      ▼
                    emitChange()
                      │
                      ▼
                    イベントシステム ───▶ processWebhookTrigger()
                                              │
                                              ▼
                                        WebhookTrigger ───▶ HTTP POST
                                              │              (target_url)
                                              │
                                              ▼
                                        webhooksテーブル更新
                                        (last_triggered_*)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| post.js | `ghost/core/core/server/models/post.js` | ソース | 投稿モデル、イベント発火 |
| webhook.js | `ghost/core/core/server/models/webhook.js` | ソース | Webhookモデル |
| listen.js | `ghost/core/core/server/services/webhooks/listen.js` | ソース | イベントリスナー登録 |
| webhook-trigger.js | `ghost/core/core/server/services/webhooks/webhook-trigger.js` | ソース | Webhook送信処理 |
| payload.js | `ghost/core/core/server/services/webhooks/payload.js` | ソース | ペイロード生成 |
| serialize.js | `ghost/core/core/server/services/webhooks/serialize.js` | ソース | モデルシリアライズ |
| schema.js | `ghost/core/core/server/data/schema/schema.js` | 設定 | DBスキーマ定義 |
| posts.test.js | `ghost/core/test/e2e-webhooks/posts.test.js` | テスト | E2Eテスト（313-362行目） |
