# 通知設計書 4-購読確認メール

## 概要

本ドキュメントは、Ghost CMSにおける購読確認メール（Newsletter Subscribe確認メール）の設計仕様を記載する。既存会員がニュースレターの購読を申し込んだ際に送信されるメールアドレス確認メールの送信ロジック、テンプレート構造、およびデータフローを定義する。

### 本通知の処理概要

本通知は、ユーザーがニュースレターの購読を申し込んだ際に、メールアドレスの確認を行うためのリンクを含むメールを送信する機能である。

**業務上の目的・背景**：ニュースレター購読時のメールアドレス検証を行い、スパム購読や第三者による不正登録を防止する。ダブルオプトイン形式を採用することで、配信リストの品質を維持し、メール到達率の向上とスパム苦情の削減を図る。

**通知の送信タイミング**：ユーザーがニュースレター購読フォーム（Portal等）でメールアドレスを入力し、購読ボタンをクリックした時点でトリガーされる。emailType='subscribe'のリクエストが送信される。

**通知の受信者**：購読を申し込んだユーザーのメールアドレスに送信される。既存会員でも新規ユーザーでも送信される。

**通知内容の概要**：メールにはメールアドレス確認用のマジックリンクが含まれる。リンクをクリックすることでメールアドレスの検証が完了し、ニュースレターの購読が有効化される。リンクは24時間で有効期限が切れる。

**期待されるアクション**：受信者はメール内の「Confirm email address」ボタンをクリックして購読を確定する。

## 通知種別

メール通知（トランザクションメール）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 無 |

### 送信先決定ロジック

1. クライアントからのリクエストボディに含まれるメールアドレスを取得
2. メールアドレスの正規化を実行
3. バリデーションチェック後、確認メールを送信

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | サイト設定の`members_support_address`または`noreply@[サイトドメイン]` |
| 送信元名称 | サイトタイトル |
| 件名 | `Confirm your subscription to {siteTitle}` |
| 形式 | HTML + テキスト（マルチパート） |

### 本文テンプレート

```html
件名: Confirm your subscription to {siteTitle}

本文:
Hey there,

You're one tap away from subscribing to {siteTitle} - please confirm your email address with this link:

[Confirm email address ボタン]

For your security, the link will expire in 24 hours time.

All the best!

---
You can also copy & paste this URL into your browser:
{magicLinkUrl}

If you did not make this request, you can simply delete this message.
You will not be subscribed.

This message was sent from {siteDomain} to {email}.
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 本通知には添付ファイルはない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| siteTitle | サイト名 | settingsCache.get('title') | Yes |
| email | 送信先メールアドレス | リクエストボディ | Yes |
| url | マジックリンクURL | tokenProvider.create() + getSigninURL() | Yes |
| accentColor | サイトのアクセントカラー | settingsCache.get('accent_color') | No（デフォルト: #15212A） |
| siteDomain | サイトドメイン | urlUtils.getSiteUrl()から抽出 | Yes |
| siteUrl | サイトURL | urlUtils.getSiteUrl() | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | POST /members/api/send-magic-link | emailType='subscribe' | ニュースレター購読フォームからの送信 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 無効なメールアドレス | isEmail()バリデーションを通過しない場合 |
| ハニーポット検出 | honeypotフィールドに値がある場合 |
| ブロックドメイン | ブロックリストに含まれるドメインの場合 |
| 招待制限 | セルフサインアップが無効の場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[POST /members/api/send-magic-link] --> B[メールアドレス正規化]
    B --> C{バリデーション}
    C -->|失敗| D[400 Bad Request]
    C -->|成功| E{セルフサインアップ許可?}
    E -->|No| F[エラー]
    E -->|Yes| G{会員存在確認}
    G -->|存在する| H[signinメールにフォールバック]
    G -->|存在しない| I[subscribeテンプレート使用]
    I --> J[トークン生成]
    J --> K[メール送信]
    K --> L[201 Created]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| members | 会員存在確認 | email列で検索 |
| settings | サイト設定取得 | settingsCacheから取得 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| tokens | INSERT | マジックリンクトークンの保存 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| BadRequestError | メールアドレスが不正 | 400エラーを返却 |
| BadRequestError | セルフサインアップ無効 | エラーメッセージを返却 |
| EENVELOPE | メール送信エラー | 400エラーを返却 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 設定なし |
| 1日あたり上限 | 設定なし |

### 配信時間帯

特定の配信時間帯制限はない。

## セキュリティ考慮事項

- マジックリンクトークンは24時間で有効期限切れ
- ダブルオプトインによるスパム購読防止
- ハニーポットフィールドによるボット対策

## 備考

- subscribeタイプは既存会員の場合signinにフォールバックする
- 新規ユーザーの場合は、確認完了時に会員アカウントも作成される
- トークンにはnewsletters情報が含まれ、確認完了時に購読設定が反映される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | subscribe.js | `ghost/core/core/server/services/members/emails/subscribe.js` | 「Confirm your subscription」メッセージ、signup.jsとの違い |

**読解のコツ**: subscribe.jsは購読確認専用のテンプレート。件名とpreheaderの内容が購読に特化している点に注目。

#### Step 2: APIコントローラーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | router-controller.js | `ghost/core/core/server/services/members/members-api/controllers/router-controller.js` | emailType='subscribe'の処理フロー（716行目） |

**主要処理フロー**:
- **716行目**: emailTypeのデフォルトが'subscribe'
- **725-726行目**: signup/subscribeの場合_handleSignup呼び出し

### プログラム呼び出し階層図

```
POST /members/api/send-magic-link (emailType='subscribe')
    │
    ├─ RouterController.sendMagicLink()
    │      │
    │      ├─ _handleSignup() (subscribeはsignupとして処理)
    │      │      │
    │      │      └─ sendEmailWithMagicLink()
    │      │             │
    │      │             └─ MagicLink.sendMagicLink()
    │      │                    │
    │      │                    └─ subscribe.js テンプレート
    │
    └─ getSniperLinks()
```

### データフロー図

```
[入力]                      [処理]                           [出力]

リクエストボディ ───────▶ RouterController
  - email                      │
  - emailType='subscribe'      ▼
  - newsletters           メールアドレス正規化
                               │
                               ▼
                         トークン生成
                         （newsletters含む）
                               │
                               ▼
                         メール送信 ─────────▶ ユーザーのメールボックス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| subscribe.js | `ghost/core/core/server/services/members/emails/subscribe.js` | テンプレート | 購読確認メールのHTMLテンプレート |
| router-controller.js | `ghost/core/core/server/services/members/members-api/controllers/router-controller.js` | コントローラー | APIエンドポイント実装 |
| magic-link.js | `ghost/core/core/server/services/lib/magic-link/magic-link.js` | ライブラリ | マジックリンク送信 |
