# 通知設計書 41-page.unscheduled

## 概要

本ドキュメントは、Ghost CMSにおける `page.unscheduled` Webhookイベントの設計仕様を定義する。このWebhookは、スケジュールされていたページのスケジュールが解除された際に、登録されたWebhookエンドポイントに通知を送信する機能を提供する。

### 本通知の処理概要

このWebhookは、予約公開が設定されていたページの公開スケジュールが解除（キャンセル）された際に、外部システムへリアルタイムで通知を送信する機能を提供する。

**業務上の目的・背景**：ページのスケジュール解除は、コンテンツ管理ワークフローにおいて重要なイベントである。予約公開の取り消しを外部システム（CMS連携ツール、コンテンツ配信システム、分析プラットフォームなど）に通知することで、コンテンツ公開計画の変更を関連システムに即座に反映させることができる。これにより、マーケティングチームやコンテンツ管理チームは、公開スケジュールの変更を自動的に追跡・管理できる。

**通知の送信タイミング**：ページのステータスが `scheduled`（予約公開）から `draft` や他のステータスに変更された際にトリガーされる。具体的には、Postモデル（typeがpageの場合）の `onUpdated` フック内で、`wasScheduled` かつ `!isScheduled` かつ `!isPublished` の条件を満たした場合に `unscheduled` イベントが発火される。

**通知の受信者**：Ghost管理画面で設定された `page.unscheduled` イベントに対応するWebhookエンドポイント。これらはIntegration（連携機能）を通じて登録される外部システムのURLである。

**通知内容の概要**：スケジュール解除されたページの現在の状態（current）と、変更前の状態（previous）を含むJSONペイロード。ページの基本情報（ID、タイトル、スラッグ、ステータスなど）に加え、タグや著者の関連情報も含まれる。

**期待されるアクション**：受信側システムは、スケジュールキャンセルの通知を受け取り、予約公開リストからの削除、公開カレンダーの更新、関係者への通知、連携システムの状態更新などの処理を実行することが期待される。

## 通知種別

Webhook（HTTP POST リクエスト）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（イベント駆動） |
| 優先度 | 中 |
| リトライ | 有・5回（テスト環境では0回） |

### 送信先決定ロジック

1. `webhooks` テーブルから `event = 'page.unscheduled'` に一致するレコードを取得
2. カスタムインテグレーション制限（`customIntegrations` limit）が有効な場合は、内部インテグレーション（`type = 'internal'`）に紐づくWebhookのみを対象とする
3. 各Webhookの `target_url` に対してHTTP POSTリクエストを送信

## 通知テンプレート

### Webhook通知の場合

| 項目 | 内容 |
|-----|------|
| HTTPメソッド | POST |
| Content-Type | application/json |
| Content-Version | v{Ghost APIバージョン} |
| タイムアウト | 2000ms（2秒） |

### ペイロード構造

```json
{
  "page": {
    "current": {
      "id": "ページID",
      "uuid": "UUID",
      "title": "ページタイトル",
      "slug": "ページスラッグ",
      "status": "draft",
      "visibility": "public",
      "created_at": "作成日時",
      "updated_at": "更新日時",
      "published_at": null,
      "tags": [...],
      "authors": [...]
    },
    "previous": {
      "status": "scheduled",
      "published_at": "予定されていた公開日時"
    }
  }
}
```

### 署名ヘッダー（オプション）

Webhookに `secret` が設定されている場合、以下のヘッダーが追加される：

| ヘッダー名 | 形式 |
|----------|------|
| X-Ghost-Signature | `sha256={HMAC署名}, t={タイムスタンプ}` |

署名の生成: `HMAC-SHA256(payload + timestamp, secret)`

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| page.current.id | ページの一意識別子 | posts.id | Yes |
| page.current.uuid | ページのUUID | posts.uuid | Yes |
| page.current.title | ページタイトル | posts.title | Yes |
| page.current.slug | ページスラッグ | posts.slug | Yes |
| page.current.status | 現在のステータス | posts.status | Yes |
| page.current.visibility | 公開範囲 | posts.visibility | Yes |
| page.current.html | HTML本文 | posts.html | No |
| page.current.plaintext | プレーンテキスト本文 | posts.plaintext | No |
| page.current.tags | 関連タグ | posts_tags, tags | No |
| page.current.authors | 著者情報 | posts_authors, users | No |
| page.previous | 変更前の値（変更されたフィールドのみ） | モデルの_previousAttributes | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | ページ編集で予約公開を解除 | status: scheduled → draft | 管理画面でスケジュールを解除 |
| API | Admin API経由でステータス変更 | status: scheduled → draft | PUT /admin/pages/:id |
| スケジューラ | 予約公開の取り消し | wasScheduled && !isScheduled && !isPublished | 公開前のキャンセル |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| options.importing === true | インポート処理中は送信しない |
| 対象Webhookが存在しない | page.unscheduledイベントに登録されたWebhookがない場合 |
| customIntegrations制限超過 | カスタムインテグレーション数制限を超えている場合は内部インテグレーションのみ |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ページ更新操作] --> B[Post.onUpdated発火]
    B --> C{typeがpageか?}
    C -->|Yes| D{wasScheduled && !isScheduled && !isPublished?}
    C -->|No| Z[処理終了]
    D -->|Yes| E[page.unscheduledイベント発火]
    D -->|No| Z
    E --> F[WebhookTrigger.trigger呼び出し]
    F --> G[Webhook.findAllByEvent実行]
    G --> H{対象Webhook存在?}
    H -->|No| Z
    H -->|Yes| I[ペイロード生成]
    I --> J[各Webhookに対してHTTP POST]
    J --> K{送信成功?}
    K -->|Yes| L[last_triggered_at更新]
    K -->|No| M{ステータス410?}
    M -->|Yes| N[Webhook削除]
    M -->|No| O[last_triggered_error記録]
    L --> Z
    N --> Z
    O --> Z
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| webhooks | 対象Webhookの取得 | event='page.unscheduled' |
| integrations | Webhook連携先の確認 | 内部インテグレーション判定用 |
| posts | ページデータの取得 | type='page' |
| tags | タグ情報の取得 | ペイロード生成用 |
| users | 著者情報の取得 | ペイロード生成用 |

### テーブル別参照項目詳細

#### webhooks

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | Webhook識別 | - |
| event | イベント種別 | event = 'page.unscheduled' |
| target_url | 送信先URL | - |
| secret | 署名生成用シークレット | NULLでない場合のみ使用 |
| integration_id | 連携先の識別 | インテグレーション制限判定用 |

#### posts

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id, uuid, title, slug | ページ基本情報 | type = 'page' |
| status | ステータス（変更後） | - |
| html, plaintext | 本文コンテンツ | formats指定時 |
| visibility | 公開範囲 | - |
| published_at | 公開予定日時 | - |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| webhooks | UPDATE | 送信結果の記録 |

#### 送信結果更新

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | last_triggered_at | Date.now() | 送信日時 |
| UPDATE | last_triggered_status | HTTPステータスコード | 成功/失敗時 |
| UPDATE | last_triggered_error | エラーメッセージまたはNULL | 失敗時のみ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| タイムアウト | 2秒以内に応答なし | リトライ実行 |
| 410 Gone | 受信側がWebhook削除を要求 | Webhookレコードを削除 |
| 接続エラー | ネットワーク障害 | リトライ実行、エラーログ記録 |
| 5xx エラー | サーバー側エラー | リトライ実行、エラーログ記録 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 5回（本番環境）、0回（テスト環境） |
| リトライ間隔 | @tryghost/requestのデフォルト設定に従う |
| リトライ対象エラー | タイムアウト、接続エラー、5xxエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（イベント発生ごとに送信） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

送信可能な時間帯の制限なし。イベント発生時に即座に送信される。

## セキュリティ考慮事項

- **署名検証**: Webhookに `secret` が設定されている場合、`X-Ghost-Signature` ヘッダーでHMAC-SHA256署名を提供。受信側での改ざん検知が可能
- **HTTPS推奨**: `target_url` にはHTTPS URLの使用を推奨
- **タイムスタンプ**: 署名にタイムスタンプを含めることでリプレイ攻撃を防止
- **インテグレーション制限**: プラン制限により、カスタムインテグレーションの使用を制御可能

## 備考

- Postモデルは `type` フィールドで投稿（post）とページ（page）を区別する
- ページのスケジュール解除イベントは、投稿（post.unscheduled）と同じロジックで処理される
- `emitChange` メソッドで `resourceType`（page）を付加してイベント名を構成

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Webhookとページの基本構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | schema.js | `ghost/core/core/server/data/schema/schema.js` | webhooksテーブル（353-370行目）とpostsテーブル（61-105行目）の定義を確認 |
| 1-2 | webhook.js | `ghost/core/core/server/models/webhook.js` | Webhookモデルの構造と`findAllByEvent`メソッド（46-53行目） |

**読解のコツ**: スキーマ定義でWebhookの各フィールド（event, target_url, secret等）の役割を把握する。

#### Step 2: エントリーポイントを理解する

イベント発火の起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | post.js | `ghost/core/core/server/models/post.js` | `onUpdated`メソッド（394-464行目）でスケジュール解除の判定ロジックを確認 |

**主要処理フロー**:
1. **394行目**: `onUpdated`メソッドの開始
2. **401行目**: `wasScheduled`（以前がscheduledだったか）の判定
3. **444-446行目**: `wasScheduled && !isScheduled && !isPublished` の条件で `unscheduled` イベント発火
4. **356-366行目**: `emitChange`メソッドでイベント名を構成（resourceType + '.' + event）

#### Step 3: イベントリスナーの登録を理解する

Webhookシステムがどのようにイベントを購読するか。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | listen.js | `ghost/core/core/server/services/webhooks/listen.js` | WEBHOOKSリスト（10-45行目）と`listen`関数（47-68行目） |

**主要処理フロー**:
- **30行目**: `page.unscheduled` がWEBHOOKSリストに定義
- **59-66行目**: `events.on`でイベントリスナーを登録、`webhookTrigger.trigger`を呼び出し

#### Step 4: Webhook送信処理を理解する

実際のHTTPリクエスト送信ロジック。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | webhook-trigger.js | `ghost/core/core/server/services/webhooks/webhook-trigger.js` | `trigger`メソッド（98-143行目）で送信処理全体を把握 |
| 4-2 | payload.js | `ghost/core/core/server/services/webhooks/payload.js` | ペイロード生成の委譲ロジック |
| 4-3 | serialize.js | `ghost/core/core/server/services/webhooks/serialize.js` | リソースのシリアライズ処理（1-82行目） |

**主要処理フロー**:
- **104行目**: `getAll`でイベントに対応するWebhookを取得
- **109行目**: `payload`関数でペイロード生成
- **116-124行目**: リクエストヘッダー構成（署名含む）
- **139-141行目**: HTTPリクエスト送信と結果処理

### プログラム呼び出し階層図

```
Post.onUpdated (models/post.js:394)
    │
    ├─ emitChange('unscheduled') (models/post.js:445)
    │      │
    │      └─ events.emit('page.unscheduled') (lib/common/events.js)
    │             │
    │             └─ processWebhookTrigger (services/webhooks/listen.js:59)
    │                    │
    │                    └─ WebhookTrigger.trigger (services/webhooks/webhook-trigger.js:98)
    │                           │
    │                           ├─ getAll('page.unscheduled') (webhook-trigger.js:23)
    │                           │      └─ Webhook.findAllByEvent (models/webhook.js:46)
    │                           │
    │                           ├─ payload() (services/webhooks/payload.js)
    │                           │      └─ serialize() (services/webhooks/serialize.js)
    │                           │
    │                           └─ request(url, opts) (HTTP送信)
    │                                  │
    │                                  ├─ onSuccess → update() (webhook-trigger.js:73)
    │                                  └─ onError → update() / destroy() (webhook-trigger.js:81)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ページ更新               Post.onUpdated
(status変更)   ────▶    wasScheduled判定   ────▶     イベント発火
                              │                         │
                              ▼                         ▼
                        page.unscheduled          WebhookTrigger
                        イベント                       │
                              │                        ▼
                              │                   findAllByEvent
                              │                   (webhooksテーブル)
                              │                        │
                              ▼                        ▼
                        serialize()               HTTP POST
                        (ペイロード生成)          (target_url)
                              │                        │
                              ▼                        ▼
                        {page: {                  外部システム
                          current: {...},
                          previous: {...}
                        }}
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| listen.js | `ghost/core/core/server/services/webhooks/listen.js` | ソース | イベントリスナー登録 |
| webhook-trigger.js | `ghost/core/core/server/services/webhooks/webhook-trigger.js` | ソース | Webhook送信制御 |
| payload.js | `ghost/core/core/server/services/webhooks/payload.js` | ソース | ペイロード生成エントリ |
| serialize.js | `ghost/core/core/server/services/webhooks/serialize.js` | ソース | リソースシリアライズ |
| post.js | `ghost/core/core/server/models/post.js` | ソース | ページモデル・イベント発火 |
| webhook.js | `ghost/core/core/server/models/webhook.js` | ソース | Webhookモデル定義 |
| events.js | `ghost/core/core/server/lib/common/events.js` | ソース | イベントエミッター |
| schema.js | `ghost/core/core/server/data/schema/schema.js` | 設定 | DBスキーマ定義 |
