# 通知設計書 43-tag.added

## 概要

本ドキュメントは、Ghost CMSにおける `tag.added` Webhookイベントの設計仕様を定義する。このWebhookは、新しいタグが作成された際に、登録されたWebhookエンドポイントに通知を送信する機能を提供する。

### 本通知の処理概要

このWebhookは、Ghost CMSで新規タグが作成された際に、外部システムへリアルタイムで通知を送信する機能を提供する。

**業務上の目的・背景**：タグはコンテンツの分類・整理に使用される重要なメタデータである。新しいタグの作成を外部システム（検索エンジン、コンテンツ管理システム、分析プラットフォーム、タクソノミー管理ツールなど）に通知することで、コンテンツ分類体系の同期を維持できる。また、タグに基づいたフィルタリングや集計機能を持つ外部サービスとの連携において、リアルタイムなタグ同期は不可欠である。

**通知の送信タイミング**：Tagモデルの `onCreated` フックが呼び出された際に `tag.added` イベントが発火される。これはタグの新規作成（Admin APIまたは管理画面経由）が完了したタイミングで発生する。

**通知の受信者**：Ghost管理画面で設定された `tag.added` イベントに対応するWebhookエンドポイント。これらはIntegration（連携機能）を通じて登録される外部システムのURLである。

**通知内容の概要**：作成されたタグの全情報を含むJSONペイロード。タグの基本情報（ID、名前、スラッグ、説明、可視性など）およびSEO関連情報（メタタイトル、メタディスクリプション、OG画像など）が含まれる。

**期待されるアクション**：受信側システムは、新規タグの通知を受け取り、タグマスターの追加、検索インデックスの更新、分類体系への反映、タグ一覧の更新などの処理を実行することが期待される。

## 通知種別

Webhook（HTTP POST リクエスト）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（イベント駆動） |
| 優先度 | 中 |
| リトライ | 有・5回（テスト環境では0回） |

### 送信先決定ロジック

1. `webhooks` テーブルから `event = 'tag.added'` に一致するレコードを取得
2. カスタムインテグレーション制限（`customIntegrations` limit）が有効な場合は、内部インテグレーション（`type = 'internal'`）に紐づくWebhookのみを対象とする
3. 各Webhookの `target_url` に対してHTTP POSTリクエストを送信

## 通知テンプレート

### Webhook通知の場合

| 項目 | 内容 |
|-----|------|
| HTTPメソッド | POST |
| Content-Type | application/json |
| Content-Version | v{Ghost APIバージョン} |
| タイムアウト | 2000ms（2秒） |

### ペイロード構造

```json
{
  "tag": {
    "current": {
      "id": "タグID",
      "name": "タグ名",
      "slug": "タグスラッグ",
      "description": "タグの説明",
      "feature_image": "特集画像URL",
      "visibility": "public",
      "og_image": "OG画像URL",
      "og_title": "OGタイトル",
      "og_description": "OG説明",
      "twitter_image": "Twitter画像URL",
      "twitter_title": "Twitterタイトル",
      "twitter_description": "Twitter説明",
      "meta_title": "メタタイトル",
      "meta_description": "メタ説明",
      "codeinjection_head": "ヘッドコードインジェクション",
      "codeinjection_foot": "フッターコードインジェクション",
      "canonical_url": "カノニカルURL",
      "accent_color": "アクセントカラー",
      "created_at": "作成日時",
      "updated_at": "更新日時"
    },
    "previous": {}
  }
}
```

### 署名ヘッダー（オプション）

Webhookに `secret` が設定されている場合、以下のヘッダーが追加される：

| ヘッダー名 | 形式 |
|----------|------|
| X-Ghost-Signature | `sha256={HMAC署名}, t={タイムスタンプ}` |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| tag.current.id | タグの一意識別子 | tags.id | Yes |
| tag.current.name | タグ名 | tags.name | Yes |
| tag.current.slug | タグスラッグ（URL用） | tags.slug | Yes |
| tag.current.description | タグの説明文 | tags.description | No |
| tag.current.feature_image | 特集画像URL | tags.feature_image | No |
| tag.current.visibility | 可視性（public/internal） | tags.visibility | Yes |
| tag.current.og_image | Open Graph画像URL | tags.og_image | No |
| tag.current.og_title | Open Graphタイトル | tags.og_title | No |
| tag.current.og_description | Open Graph説明 | tags.og_description | No |
| tag.current.meta_title | SEOメタタイトル | tags.meta_title | No |
| tag.current.meta_description | SEOメタ説明 | tags.meta_description | No |
| tag.current.accent_color | アクセントカラー | tags.accent_color | No |
| tag.current.created_at | 作成日時 | tags.created_at | Yes |
| tag.previous | 変更前の値（新規作成のため空オブジェクト） | - | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | 管理画面でタグを新規作成 | Tag.onCreated発火 | 設定 > タグ から新規作成 |
| API | Admin API経由でタグ作成 | Tag.onCreated発火 | POST /admin/tags |
| 投稿時 | 投稿に新規タグを設定 | Tag.onCreated発火 | 投稿編集画面で未存在タグを追加 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| options.importing === true | インポート処理中は送信しない |
| 対象Webhookが存在しない | tag.addedイベントに登録されたWebhookがない場合 |
| customIntegrations制限超過 | カスタムインテグレーション数制限を超えている場合は内部インテグレーションのみ |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[タグ作成操作] --> B[Tag.onCreated発火]
    B --> C[emitChange'added'呼び出し]
    C --> D[tag.addedイベント発火]
    D --> E[WebhookTrigger.trigger呼び出し]
    E --> F[Webhook.findAllByEvent実行]
    F --> G{対象Webhook存在?}
    G -->|No| Z[処理終了]
    G -->|Yes| H[ペイロード生成]
    H --> I[各Webhookに対してHTTP POST]
    I --> J{送信成功?}
    J -->|Yes| K[last_triggered_at更新]
    J -->|No| L{ステータス410?}
    L -->|Yes| M[Webhook削除]
    L -->|No| N[last_triggered_error記録]
    K --> Z
    M --> Z
    N --> Z
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| webhooks | 対象Webhookの取得 | event='tag.added' |
| integrations | Webhook連携先の確認 | 内部インテグレーション判定用 |
| tags | タグデータの取得 | 新規作成されたタグ |

### テーブル別参照項目詳細

#### webhooks

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | Webhook識別 | - |
| event | イベント種別 | event = 'tag.added' |
| target_url | 送信先URL | - |
| secret | 署名生成用シークレット | NULLでない場合のみ使用 |
| integration_id | 連携先の識別 | インテグレーション制限判定用 |

#### tags

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id, name, slug | タグ基本情報 | 作成されたタグ |
| description | タグ説明 | - |
| feature_image | 特集画像 | - |
| visibility | 可視性 | public または internal |
| og_*, twitter_*, meta_* | SEO関連情報 | - |
| accent_color | アクセントカラー | - |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| webhooks | UPDATE | 送信結果の記録 |

#### 送信結果更新

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | last_triggered_at | Date.now() | 送信日時 |
| UPDATE | last_triggered_status | HTTPステータスコード | 成功/失敗時 |
| UPDATE | last_triggered_error | エラーメッセージまたはNULL | 失敗時のみ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| タイムアウト | 2秒以内に応答なし | リトライ実行 |
| 410 Gone | 受信側がWebhook削除を要求 | Webhookレコードを削除 |
| 接続エラー | ネットワーク障害 | リトライ実行、エラーログ記録 |
| 5xx エラー | サーバー側エラー | リトライ実行、エラーログ記録 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 5回（本番環境）、0回（テスト環境） |
| リトライ間隔 | @tryghost/requestのデフォルト設定に従う |
| リトライ対象エラー | タイムアウト、接続エラー、5xxエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（イベント発生ごとに送信） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

送信可能な時間帯の制限なし。イベント発生時に即座に送信される。

## セキュリティ考慮事項

- **署名検証**: Webhookに `secret` が設定されている場合、`X-Ghost-Signature` ヘッダーでHMAC-SHA256署名を提供
- **HTTPS推奨**: `target_url` にはHTTPS URLの使用を推奨
- **タイムスタンプ**: 署名にタイムスタンプを含めることでリプレイ攻撃を防止
- **内部タグ**: visibility='internal'のタグ（#で始まる名前）も通知対象となる点に注意

## 備考

- タグ名が`#`で始まる場合、自動的に `visibility: 'internal'` が設定される（tag.js 115-117行目）
- タグのスラッグは自動生成され、重複チェックが行われる
- parent_idカラムは将来の階層タグ機能用に予約されている

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Webhookとタグの基本構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | schema.js | `ghost/core/core/server/data/schema/schema.js` | webhooksテーブル（353-370行目）とtagsテーブル（268-296行目）の定義を確認 |
| 1-2 | tag.js | `ghost/core/core/server/models/tag.js` | Tagモデルの構造、defaults、onCreatedメソッド |

**読解のコツ**: tagsテーブルのvisibilityカラム（public/internal）と、内部タグ（#始まり）の自動判定ロジックを理解する。

#### Step 2: エントリーポイントを理解する

イベント発火の起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | tag.js | `ghost/core/core/server/models/tag.js` | `onCreated`メソッド（83-87行目）と`emitChange`メソッド（78-81行目） |

**主要処理フロー**:
1. **83行目**: `onCreated`メソッドの開始
2. **84行目**: 親クラスの`onCreated`を呼び出し
3. **86行目**: `emitChange('added', options)` でイベント発火
4. **78-80行目**: `emitChange`で `'tag.' + 'added'` = `'tag.added'` イベントを構成

#### Step 3: イベントリスナーの登録を理解する

Webhookシステムがどのようにイベントを購読するか。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | listen.js | `ghost/core/core/server/services/webhooks/listen.js` | WEBHOOKSリスト（10-45行目）と`listen`関数（47-68行目） |

**主要処理フロー**:
- **33行目**: `tag.added` がWEBHOOKSリストに定義
- **59-66行目**: `events.on`でイベントリスナーを登録、`webhookTrigger.trigger`を呼び出し

#### Step 4: Webhook送信処理を理解する

実際のHTTPリクエスト送信ロジック。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | webhook-trigger.js | `ghost/core/core/server/services/webhooks/webhook-trigger.js` | `trigger`メソッド（98-143行目）で送信処理全体を把握 |
| 4-2 | serialize.js | `ghost/core/core/server/services/webhooks/serialize.js` | リソースのシリアライズ処理（7-8行目でtagsを処理） |

**主要処理フロー**:
- **104行目**: `getAll`でイベントに対応するWebhookを取得
- **109行目**: `payload`関数でペイロード生成
- **serialize.js 7行目**: `resourceName = event.match(/(\w+)\./)[1]` で'tag'を抽出
- **serialize.js 8行目**: `docName = 'tags'` としてAPIシリアライザーを使用

### プログラム呼び出し階層図

```
Tag.onCreated (models/tag.js:83)
    │
    └─ emitChange('added') (models/tag.js:86)
           │
           └─ events.emit('tag.added') (lib/common/events.js)
                  │
                  └─ processWebhookTrigger (services/webhooks/listen.js:59)
                         │
                         └─ WebhookTrigger.trigger (services/webhooks/webhook-trigger.js:98)
                                │
                                ├─ getAll('tag.added') (webhook-trigger.js:23)
                                │      └─ Webhook.findAllByEvent (models/webhook.js:46)
                                │
                                ├─ payload() (services/webhooks/payload.js)
                                │      └─ serialize() (services/webhooks/serialize.js)
                                │             └─ API serializers (tags)
                                │
                                └─ request(url, opts) (HTTP送信)
                                       │
                                       ├─ onSuccess → update() (webhook-trigger.js:73)
                                       └─ onError → update() / destroy() (webhook-trigger.js:81)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

タグ作成                 Tag.onCreated
(API/管理画面)  ────▶    emitChange('added')  ────▶   イベント発火
                              │                         │
                              ▼                         ▼
                        tag.added                 WebhookTrigger
                        イベント                       │
                              │                        ▼
                              │                   findAllByEvent
                              │                   (webhooksテーブル)
                              │                        │
                              ▼                        ▼
                        serialize()               HTTP POST
                        (ペイロード生成)          (target_url)
                              │                        │
                              ▼                        ▼
                        {tag: {                   外部システム
                          current: {
                            name, slug, ...
                          },
                          previous: {}
                        }}
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| listen.js | `ghost/core/core/server/services/webhooks/listen.js` | ソース | イベントリスナー登録 |
| webhook-trigger.js | `ghost/core/core/server/services/webhooks/webhook-trigger.js` | ソース | Webhook送信制御 |
| payload.js | `ghost/core/core/server/services/webhooks/payload.js` | ソース | ペイロード生成エントリ |
| serialize.js | `ghost/core/core/server/services/webhooks/serialize.js` | ソース | リソースシリアライズ |
| tag.js | `ghost/core/core/server/models/tag.js` | ソース | Tagモデル・イベント発火 |
| webhook.js | `ghost/core/core/server/models/webhook.js` | ソース | Webhookモデル定義 |
| events.js | `ghost/core/core/server/lib/common/events.js` | ソース | イベントエミッター |
| schema.js | `ghost/core/core/server/data/schema/schema.js` | 設定 | DBスキーマ定義 |
