# 通知設計書 44-tag.edited

## 概要

本ドキュメントは、Ghost CMSにおける `tag.edited` Webhookイベントの設計仕様を定義する。このWebhookは、既存のタグが編集された際に、登録されたWebhookエンドポイントに通知を送信する機能を提供する。

### 本通知の処理概要

このWebhookは、Ghost CMSで既存タグの情報が更新された際に、外部システムへリアルタイムで通知を送信する機能を提供する。

**業務上の目的・背景**：タグの名前、スラッグ、説明、SEO情報などの変更は、コンテンツの分類体系やSEO戦略に影響を与える重要な操作である。タグの変更を外部システム（検索エンジン、コンテンツ管理システム、分析プラットフォームなど）に即座に通知することで、コンテンツ分類の整合性を維持し、URLの変更（スラッグ変更時）への対応や、SEO情報の同期を可能にする。

**通知の送信タイミング**：Tagモデルの `onUpdated` フックが呼び出された際に `tag.edited` イベントが発火される。これはタグの編集（Admin APIまたは管理画面経由）が完了したタイミングで発生する。

**通知の受信者**：Ghost管理画面で設定された `tag.edited` イベントに対応するWebhookエンドポイント。これらはIntegration（連携機能）を通じて登録される外部システムのURLである。

**通知内容の概要**：編集されたタグの現在の状態（current）と、変更前の状態（previous）を含むJSONペイロード。previousには変更されたフィールドのみが含まれ、差分の把握が容易になる。

**期待されるアクション**：受信側システムは、タグ変更の通知を受け取り、タグマスターの更新、検索インデックスの再構築、URLリダイレクトの設定（スラッグ変更時）、関連コンテンツの再インデックスなどの処理を実行することが期待される。

## 通知種別

Webhook（HTTP POST リクエスト）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（イベント駆動） |
| 優先度 | 中 |
| リトライ | 有・5回（テスト環境では0回） |

### 送信先決定ロジック

1. `webhooks` テーブルから `event = 'tag.edited'` に一致するレコードを取得
2. カスタムインテグレーション制限（`customIntegrations` limit）が有効な場合は、内部インテグレーション（`type = 'internal'`）に紐づくWebhookのみを対象とする
3. 各Webhookの `target_url` に対してHTTP POSTリクエストを送信

## 通知テンプレート

### Webhook通知の場合

| 項目 | 内容 |
|-----|------|
| HTTPメソッド | POST |
| Content-Type | application/json |
| Content-Version | v{Ghost APIバージョン} |
| タイムアウト | 2000ms（2秒） |

### ペイロード構造

```json
{
  "tag": {
    "current": {
      "id": "タグID",
      "name": "タグ名（変更後）",
      "slug": "タグスラッグ（変更後）",
      "description": "タグの説明",
      "feature_image": "特集画像URL",
      "visibility": "public",
      "og_image": "OG画像URL",
      "og_title": "OGタイトル",
      "og_description": "OG説明",
      "twitter_image": "Twitter画像URL",
      "twitter_title": "Twitterタイトル",
      "twitter_description": "Twitter説明",
      "meta_title": "メタタイトル",
      "meta_description": "メタ説明",
      "codeinjection_head": "ヘッドコードインジェクション",
      "codeinjection_foot": "フッターコードインジェクション",
      "canonical_url": "カノニカルURL",
      "accent_color": "アクセントカラー",
      "created_at": "作成日時",
      "updated_at": "更新日時"
    },
    "previous": {
      "name": "変更前のタグ名",
      "slug": "変更前のスラッグ"
    }
  }
}
```

### 署名ヘッダー（オプション）

Webhookに `secret` が設定されている場合、以下のヘッダーが追加される：

| ヘッダー名 | 形式 |
|----------|------|
| X-Ghost-Signature | `sha256={HMAC署名}, t={タイムスタンプ}` |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| tag.current.id | タグの一意識別子 | tags.id | Yes |
| tag.current.name | タグ名（変更後） | tags.name | Yes |
| tag.current.slug | タグスラッグ（変更後） | tags.slug | Yes |
| tag.current.description | タグの説明文 | tags.description | No |
| tag.current.feature_image | 特集画像URL | tags.feature_image | No |
| tag.current.visibility | 可視性（public/internal） | tags.visibility | Yes |
| tag.current.updated_at | 更新日時 | tags.updated_at | Yes |
| tag.previous | 変更されたフィールドの変更前の値 | モデルの_previousAttributes | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | 管理画面でタグを編集 | Tag.onUpdated発火 | 設定 > タグ から編集 |
| API | Admin API経由でタグ更新 | Tag.onUpdated発火 | PUT /admin/tags/:id |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| options.importing === true | インポート処理中は送信しない |
| 対象Webhookが存在しない | tag.editedイベントに登録されたWebhookがない場合 |
| customIntegrations制限超過 | カスタムインテグレーション数制限を超えている場合は内部インテグレーションのみ |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[タグ編集操作] --> B[Tag.onUpdated発火]
    B --> C[emitChange'edited'呼び出し]
    C --> D[tag.editedイベント発火]
    D --> E[WebhookTrigger.trigger呼び出し]
    E --> F[Webhook.findAllByEvent実行]
    F --> G{対象Webhook存在?}
    G -->|No| Z[処理終了]
    G -->|Yes| H[ペイロード生成]
    H --> I[各Webhookに対してHTTP POST]
    I --> J{送信成功?}
    J -->|Yes| K[last_triggered_at更新]
    J -->|No| L{ステータス410?}
    L -->|Yes| M[Webhook削除]
    L -->|No| N[last_triggered_error記録]
    K --> Z
    M --> Z
    N --> Z
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| webhooks | 対象Webhookの取得 | event='tag.edited' |
| integrations | Webhook連携先の確認 | 内部インテグレーション判定用 |
| tags | タグデータの取得 | 編集されたタグ |

### テーブル別参照項目詳細

#### webhooks

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | Webhook識別 | - |
| event | イベント種別 | event = 'tag.edited' |
| target_url | 送信先URL | - |
| secret | 署名生成用シークレット | NULLでない場合のみ使用 |
| integration_id | 連携先の識別 | インテグレーション制限判定用 |

#### tags

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id, name, slug | タグ基本情報（変更後） | 編集されたタグ |
| description | タグ説明 | - |
| feature_image | 特集画像 | - |
| visibility | 可視性 | - |
| og_*, twitter_*, meta_* | SEO関連情報 | - |
| updated_at | 更新日時 | - |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| webhooks | UPDATE | 送信結果の記録 |

#### 送信結果更新

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | last_triggered_at | Date.now() | 送信日時 |
| UPDATE | last_triggered_status | HTTPステータスコード | 成功/失敗時 |
| UPDATE | last_triggered_error | エラーメッセージまたはNULL | 失敗時のみ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| タイムアウト | 2秒以内に応答なし | リトライ実行 |
| 410 Gone | 受信側がWebhook削除を要求 | Webhookレコードを削除 |
| 接続エラー | ネットワーク障害 | リトライ実行、エラーログ記録 |
| 5xx エラー | サーバー側エラー | リトライ実行、エラーログ記録 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 5回（本番環境）、0回（テスト環境） |
| リトライ間隔 | @tryghost/requestのデフォルト設定に従う |
| リトライ対象エラー | タイムアウト、接続エラー、5xxエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（イベント発生ごとに送信） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

送信可能な時間帯の制限なし。イベント発生時に即座に送信される。

## セキュリティ考慮事項

- **署名検証**: Webhookに `secret` が設定されている場合、`X-Ghost-Signature` ヘッダーでHMAC-SHA256署名を提供
- **HTTPS推奨**: `target_url` にはHTTPS URLの使用を推奨
- **タイムスタンプ**: 署名にタイムスタンプを含めることでリプレイ攻撃を防止

## 備考

- スラッグが変更された場合、URLも変わるため、外部システムでリダイレクト設定が必要な場合がある
- `previous` オブジェクトには変更されたフィールドのみが含まれる（serialize.js 76行目）
- タグに関連する投稿のURLは変更されないが、タグアーカイブページのURLは変更される可能性がある

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Webhookとタグの基本構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | schema.js | `ghost/core/core/server/data/schema/schema.js` | webhooksテーブル（353-370行目）とtagsテーブル（268-296行目）の定義を確認 |
| 1-2 | tag.js | `ghost/core/core/server/models/tag.js` | Tagモデルの構造、onUpdatedメソッド |

**読解のコツ**: onUpdatedはonCreatedと同様の構造で、emitChange('edited')を呼び出す点を確認。

#### Step 2: エントリーポイントを理解する

イベント発火の起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | tag.js | `ghost/core/core/server/models/tag.js` | `onUpdated`メソッド（89-93行目）と`emitChange`メソッド（78-81行目） |

**主要処理フロー**:
1. **89行目**: `onUpdated`メソッドの開始
2. **90行目**: 親クラスの`onUpdated`を呼び出し
3. **92行目**: `emitChange('edited', options)` でイベント発火
4. **78-80行目**: `emitChange`で `'tag.' + 'edited'` = `'tag.edited'` イベントを構成

#### Step 3: イベントリスナーの登録を理解する

Webhookシステムがどのようにイベントを購読するか。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | listen.js | `ghost/core/core/server/services/webhooks/listen.js` | WEBHOOKSリスト（10-45行目）と`listen`関数（47-68行目） |

**主要処理フロー**:
- **34行目**: `tag.edited` がWEBHOOKSリストに定義
- **59-66行目**: `events.on`でイベントリスナーを登録、`webhookTrigger.trigger`を呼び出し

#### Step 4: Webhook送信処理とペイロード生成を理解する

実際のHTTPリクエスト送信とprevious値の取り扱い。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | webhook-trigger.js | `ghost/core/core/server/services/webhooks/webhook-trigger.js` | `trigger`メソッド（98-143行目） |
| 4-2 | serialize.js | `ghost/core/core/server/services/webhooks/serialize.js` | previousの生成ロジック（43-64行目、71-76行目） |

**主要処理フロー**:
- **serialize.js 43行目**: `model._previousAttributes` から変更前の値を取得
- **serialize.js 71行目**: `model._changed` から変更されたキーを取得
- **serialize.js 76行目**: `_.pick(previous, changed)` で変更されたフィールドのみ抽出

### プログラム呼び出し階層図

```
Tag.onUpdated (models/tag.js:89)
    │
    └─ emitChange('edited') (models/tag.js:92)
           │
           └─ events.emit('tag.edited') (lib/common/events.js)
                  │
                  └─ processWebhookTrigger (services/webhooks/listen.js:59)
                         │
                         └─ WebhookTrigger.trigger (services/webhooks/webhook-trigger.js:98)
                                │
                                ├─ getAll('tag.edited') (webhook-trigger.js:23)
                                │      └─ Webhook.findAllByEvent (models/webhook.js:46)
                                │
                                ├─ payload() (services/webhooks/payload.js)
                                │      └─ serialize() (services/webhooks/serialize.js)
                                │             ├─ current: API serializers
                                │             └─ previous: _.pick(previousAttrs, changed)
                                │
                                └─ request(url, opts) (HTTP送信)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

タグ編集                 Tag.onUpdated
(API/管理画面)  ────▶    emitChange('edited')  ────▶   イベント発火
                              │                         │
                              ▼                         ▼
                        tag.edited                WebhookTrigger
                        イベント                       │
                              │                        ▼
                              │                   findAllByEvent
                              │                   (webhooksテーブル)
                              │                        │
                              ▼                        ▼
                        serialize()               HTTP POST
                        ・current: 現在値        (target_url)
                        ・previous: 変更分            │
                              │                        ▼
                              ▼                   外部システム
                        {tag: {
                          current: {...},
                          previous: {name: "旧名"}
                        }}
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| listen.js | `ghost/core/core/server/services/webhooks/listen.js` | ソース | イベントリスナー登録 |
| webhook-trigger.js | `ghost/core/core/server/services/webhooks/webhook-trigger.js` | ソース | Webhook送信制御 |
| payload.js | `ghost/core/core/server/services/webhooks/payload.js` | ソース | ペイロード生成エントリ |
| serialize.js | `ghost/core/core/server/services/webhooks/serialize.js` | ソース | リソースシリアライズ |
| tag.js | `ghost/core/core/server/models/tag.js` | ソース | Tagモデル・イベント発火 |
| webhook.js | `ghost/core/core/server/models/webhook.js` | ソース | Webhookモデル定義 |
| events.js | `ghost/core/core/server/lib/common/events.js` | ソース | イベントエミッター |
| schema.js | `ghost/core/core/server/data/schema/schema.js` | 設定 | DBスキーマ定義 |
