# 通知設計書 47-member.deleted

## 概要

本ドキュメントは、Ghost CMSにおける `member.deleted` Webhookイベントの設計仕様を定義する。このWebhookは、会員が削除された際に、登録されたWebhookエンドポイントに通知を送信する機能を提供する。

### 本通知の処理概要

このWebhookは、Ghost CMSで会員が削除された際に、外部システムへリアルタイムで通知を送信する機能を提供する。

**業務上の目的・背景**：会員の削除は、会員管理において重要なイベントである。会員の削除を外部システム（CRM、メールマーケティングツール、課金システム、分析プラットフォームなど）に通知することで、顧客データの整合性維持、サブスクリプションの解約処理、メーリングリストからの除外、コンプライアンス対応（GDPR等の削除権への対応）などが可能になる。

**通知の送信タイミング**：Memberモデルの `onDestroyed` フックが呼び出された際に `member.deleted` イベントが発火される。これは会員の削除（Admin APIまたは管理画面経由）が完了したタイミングで発生する。削除前に関連するラベル（labels）との紐付け解除が行われる。

**通知の受信者**：Ghost管理画面で設定された `member.deleted` イベントに対応するWebhookエンドポイント。これらはIntegration（連携機能）を通じて登録される外部システムのURLである。

**通知内容の概要**：削除された会員の最終状態を含むJSONペイロード。会員の基本情報（ID、UUID、メールアドレス、名前など）が `previous` に格納され、`current` は空オブジェクトとなる。

**期待されるアクション**：受信側システムは、会員削除の通知を受け取り、CRMからの削除、メーリングリストからの除外、関連サブスクリプションの処理、分析データの更新などの処理を実行することが期待される。

## 通知種別

Webhook（HTTP POST リクエスト）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（イベント駆動） |
| 優先度 | 中 |
| リトライ | 有・5回（テスト環境では0回） |

### 送信先決定ロジック

1. `webhooks` テーブルから `event = 'member.deleted'` に一致するレコードを取得
2. カスタムインテグレーション制限（`customIntegrations` limit）が有効な場合は、内部インテグレーション（`type = 'internal'`）に紐づくWebhookのみを対象とする
3. 各Webhookの `target_url` に対してHTTP POSTリクエストを送信

## 通知テンプレート

### Webhook通知の場合

| 項目 | 内容 |
|-----|------|
| HTTPメソッド | POST |
| Content-Type | application/json |
| Content-Version | v{Ghost APIバージョン} |
| タイムアウト | 2000ms（2秒） |

### ペイロード構造

```json
{
  "member": {
    "current": {},
    "previous": {
      "id": "削除された会員ID",
      "uuid": "削除された会員UUID",
      "email": "メールアドレス",
      "name": "会員名",
      "note": "メモ",
      "status": "free",
      "geolocation": "位置情報",
      "email_count": 10,
      "email_opened_count": 5,
      "email_open_rate": 50,
      "enable_comment_notifications": true,
      "last_seen_at": "最終アクセス日時",
      "created_at": "作成日時",
      "updated_at": "更新日時"
    }
  }
}
```

### 署名ヘッダー（オプション）

Webhookに `secret` が設定されている場合、以下のヘッダーが追加される：

| ヘッダー名 | 形式 |
|----------|------|
| X-Ghost-Signature | `sha256={HMAC署名}, t={タイムスタンプ}` |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| member.current | 現在の状態（削除済みのため空オブジェクト） | - | Yes |
| member.previous.id | 削除された会員の一意識別子 | members.id | Yes |
| member.previous.uuid | 削除された会員のUUID | members.uuid | Yes |
| member.previous.email | メールアドレス | members.email | Yes |
| member.previous.name | 会員名 | members.name | No |
| member.previous.status | 会員ステータス（free/paid/comped） | members.status | Yes |
| member.previous.email_count | 受信メール数 | members.email_count | Yes |
| member.previous.created_at | 作成日時 | members.created_at | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | 管理画面で会員を削除 | Member.onDestroyed発火 | Members > 会員詳細 > 削除 |
| API | Admin API経由で会員削除 | Member.onDestroyed発火 | DELETE /admin/members/:id |
| 一括削除 | 複数会員の一括削除 | 各会員でMember.onDestroyed発火 | Bulk delete |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| options.importing === true | インポート処理中は送信しない |
| 対象Webhookが存在しない | member.deletedイベントに登録されたWebhookがない場合 |
| customIntegrations制限超過 | カスタムインテグレーション数制限を超えている場合は内部インテグレーションのみ |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[会員削除操作] --> B[Member.onDestroying発火]
    B --> C[ラベル紐付け解除準備]
    C --> D[Member.destroy実行]
    D --> E[Member.onDestroyed発火]
    E --> F[emitChange'deleted'呼び出し]
    F --> G[member.deletedイベント発火]
    G --> H[WebhookTrigger.trigger呼び出し]
    H --> I[Webhook.findAllByEvent実行]
    I --> J{対象Webhook存在?}
    J -->|No| Z[処理終了]
    J -->|Yes| K[ペイロード生成]
    K --> L[各Webhookに対してHTTP POST]
    L --> M{送信成功?}
    M -->|Yes| N[last_triggered_at更新]
    M -->|No| O{ステータス410?}
    O -->|Yes| P[Webhook削除]
    O -->|No| Q[last_triggered_error記録]
    N --> Z
    P --> Z
    Q --> Z
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| webhooks | 対象Webhookの取得 | event='member.deleted' |
| integrations | Webhook連携先の確認 | 内部インテグレーション判定用 |
| members | 削除される会員のデータ | previous値として使用 |
| members_labels | 会員とラベルの紐付け | 削除時に解除される |

### テーブル別参照項目詳細

#### webhooks

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | Webhook識別 | - |
| event | イベント種別 | event = 'member.deleted' |
| target_url | 送信先URL | - |
| secret | 署名生成用シークレット | NULLでない場合のみ使用 |
| integration_id | 連携先の識別 | インテグレーション制限判定用 |

#### members

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id, uuid, email | 会員基本情報（削除前） | 削除対象会員 |
| name, note | 会員詳細情報 | - |
| status | 会員ステータス | - |
| email_count, email_opened_count | メール統計 | - |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| members_labels | 自動削除 | 会員とラベルの紐付け解除 |
| members | DELETE | 会員の削除 |
| webhooks | UPDATE | 送信結果の記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| タイムアウト | 2秒以内に応答なし | リトライ実行 |
| 410 Gone | 受信側がWebhook削除を要求 | Webhookレコードを削除 |
| 接続エラー | ネットワーク障害 | リトライ実行、エラーログ記録 |
| 5xx エラー | サーバー側エラー | リトライ実行、エラーログ記録 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 5回（本番環境）、0回（テスト環境） |
| リトライ間隔 | @tryghost/requestのデフォルト設定に従う |
| リトライ対象エラー | タイムアウト、接続エラー、5xxエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（イベント発生ごとに送信） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

送信可能な時間帯の制限なし。イベント発生時に即座に送信される。

## セキュリティ考慮事項

- **署名検証**: Webhookに `secret` が設定されている場合、`X-Ghost-Signature` ヘッダーでHMAC-SHA256署名を提供
- **HTTPS推奨**: `target_url` にはHTTPS URLの使用を推奨
- **個人情報**: 削除された会員の個人情報（メールアドレス等）がペイロードに含まれるため、受信側での適切な取り扱いと削除が必要
- **GDPR対応**: 削除権（Right to erasure）への対応として、外部システムでも該当データの削除処理が期待される

## 備考

- 会員削除時、email_recipientsレコードは削除されない（member.js relationshipConfig 152-154行目）。これは分析と履歴レコード用途のため
- 削除イベントでは `current` は空オブジェクト、`previous` に削除前のデータが格納される
- onDestroyingフックでhandleAttachedModelsが呼ばれ、ラベルの紐付け解除が準備される（member.js 273-277行目）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Webhookと会員の基本構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | schema.js | `ghost/core/core/server/data/schema/schema.js` | webhooksテーブル（353-370行目）とmembersテーブル（417-444行目）の定義を確認 |
| 1-2 | member.js | `ghost/core/core/server/models/member.js` | Memberモデルの構造、onDestroyed、relationshipConfig |

**読解のコツ**: email_recipientsがdestroyRelated: falseで設定されている点（履歴保持）を理解する。

#### Step 2: エントリーポイントを理解する

イベント発火の起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | member.js | `ghost/core/core/server/models/member.js` | `onDestroyed`メソッド（267-271行目）、`onDestroying`メソッド（273-277行目）、`emitChange`メソッド（250-253行目） |

**主要処理フロー**:
1. **273行目**: `onDestroying`メソッドの開始
2. **276行目**: `handleAttachedModels(model)` でラベル紐付け解除を準備
3. **267行目**: `onDestroyed`メソッドの開始
4. **268行目**: 親クラスの`onDestroyed`を呼び出し
5. **270行目**: `emitChange('deleted', options)` でイベント発火

#### Step 3: イベントリスナーの登録を理解する

Webhookシステムがどのようにイベントを購読するか。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | listen.js | `ghost/core/core/server/services/webhooks/listen.js` | WEBHOOKSリスト（10-45行目）と`listen`関数（47-68行目） |

**主要処理フロー**:
- **38行目**: `member.deleted` がWEBHOOKSリストに定義
- **59-66行目**: `events.on`でイベントリスナーを登録、`webhookTrigger.trigger`を呼び出し

#### Step 4: Webhook送信処理とペイロード生成を理解する

削除時のペイロード構造（currentが空、previousに削除前データ）。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | webhook-trigger.js | `ghost/core/core/server/services/webhooks/webhook-trigger.js` | `trigger`メソッド（98-143行目） |
| 4-2 | serialize.js | `ghost/core/core/server/services/webhooks/serialize.js` | 削除時のペイロード生成 |

**主要処理フロー**:
- **serialize.js 15行目**: `model.attributes` が空の場合の処理
- **serialize.js 37-40行目**: attributesが空の場合は空オブジェクトを返す
- **serialize.js 43行目**: `model._previousAttributes` から削除前の値を取得

### プログラム呼び出し階層図

```
Member.destroy (models/member.js:454-461)
    │
    ├─ Member.onDestroying (models/member.js:273)
    │      └─ handleAttachedModels() (ラベル紐付け解除準備)
    │
    └─ Member.onDestroyed (models/member.js:267)
           │
           └─ emitChange('deleted') (models/member.js:270)
                  │
                  └─ events.emit('member.deleted') (lib/common/events.js)
                         │
                         └─ processWebhookTrigger (services/webhooks/listen.js:59)
                                │
                                └─ WebhookTrigger.trigger (services/webhooks/webhook-trigger.js:98)
                                       │
                                       ├─ getAll('member.deleted') (webhook-trigger.js:23)
                                       │
                                       ├─ payload() (services/webhooks/payload.js)
                                       │      └─ serialize()
                                       │             ├─ current: {} (empty)
                                       │             └─ previous: 削除前データ
                                       │
                                       └─ request(url, opts) (HTTP送信)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

会員削除要求             Member.onDestroying
(API/管理画面)  ────▶    handleAttachedModels  ────▶   ラベル紐付け解除
                              │
                              ▼
                        Member.destroy ────▶ onDestroyed ────▶ イベント発火
                                                                    │
                                                                    ▼
                                                              WebhookTrigger
                                                                    │
                                                                    ▼
                        serialize()                           HTTP POST
                        ・current: {}                        (target_url)
                        ・previous: 削除前データ                    │
                              │                                    ▼
                              ▼                               外部システム
                        {member: {
                          current: {},
                          previous: {id, email, name, status, ...}
                        }}
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| listen.js | `ghost/core/core/server/services/webhooks/listen.js` | ソース | イベントリスナー登録 |
| webhook-trigger.js | `ghost/core/core/server/services/webhooks/webhook-trigger.js` | ソース | Webhook送信制御 |
| payload.js | `ghost/core/core/server/services/webhooks/payload.js` | ソース | ペイロード生成エントリ |
| serialize.js | `ghost/core/core/server/services/webhooks/serialize.js` | ソース | リソースシリアライズ |
| member.js | `ghost/core/core/server/models/member.js` | ソース | Memberモデル・削除処理・イベント発火 |
| webhook.js | `ghost/core/core/server/models/webhook.js` | ソース | Webhookモデル定義 |
| events.js | `ghost/core/core/server/lib/common/events.js` | ソース | イベントエミッター |
| schema.js | `ghost/core/core/server/data/schema/schema.js` | 設定 | DBスキーマ定義 |
