---
generated_at: 2026-01-29 12:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：1-会員サインインメール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **リトライ仕様**：コード上での明示的なリトライ処理が見当たらない
  2. **トークン有効期限24時間**：テンプレート内のテキストからの推測
  3. **OTC 6桁**：deriveOTC実装の詳細未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/services/members/emails/signin.js` - サインインメールHTMLテンプレート
- E-02: `ghost/core/core/server/services/members/members-api/controllers/router-controller.js` - APIコントローラー
- E-03: `ghost/core/core/server/services/members/members-api/members-api.js` - Members APIファクトリー
- E-04: `ghost/core/core/server/services/lib/magic-link/magic-link.js` - MagicLinkクラス
- E-05: `ghost/core/core/server/services/members/members-api/utils/normalize-email.js` - メールアドレス正規化（パスのみ確認）
- E-06: 通知一覧.csv - 通知定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | マジックリンクを含むメールが送信される | E-01, E-04 | ○ |
| C-02 | OTC（ワンタイムコード）が含まれる場合がある | E-01 (行10-13, 130-141), E-04 (行88-95) | ○ |
| C-03 | APIエンドポイントは POST /members/api/send-magic-link | E-02 (行676) | ○ |
| C-04 | emailTypeがsigninの場合に送信 | E-02 (行716-719, 857-876) | ○ |
| C-05 | 会員が存在しない場合はエラー | E-02 (行866-871) | ○ |
| C-06 | メールアドレスの正規化を実施 | E-02 (行694-700), E-05 | ○ |
| C-07 | honeypotフィールドでボット対策 | E-02 (行702-709) | ○ |
| C-08 | 件名にOTCが含まれる（OTCあり版） | E-01 (行11) | ○ |
| C-09 | 件名がSecure sign in link（OTCなし版） | E-01 (行12) | ○ |
| C-10 | テンプレート変数：siteTitle, email, url, otc, accentColor, siteDomain, siteUrl | E-01 (行2) | ○ |
| C-11 | accentColorのデフォルトは#15212A | E-01 (行2) | ○ |
| C-12 | 送信方式は同期 | E-02, E-04（sendMailをawait） | ○ |
| C-13 | sendEmailWithMagicLink関数でメール送信 | E-03 (行223-234) | ○ |
| C-14 | tokenProvider.create()でトークン生成 | E-04 (行81) | ○ |
| C-15 | getSigninURL()でマジックリンクURL生成 | E-04 (行85) | ○ |
| C-16 | transporter.sendMail()でメール送信 | E-04 (行97-102) | ○ |
| C-17 | 会員存在確認はmemberRepository.get() | E-02 (行866) | ○ |
| C-18 | リンクは24時間で有効期限切れ | E-01 (行175-176) テンプレートテキストより | ○ |
| C-19 | includeOTCがtrueの場合のみOTC生成 | E-04 (行88-95) | ○ |
| C-20 | sniperLinksがレスポンスに含まれる | E-02 (行734-741) | ○ |
| C-21 | ブロックドメインチェックあり | E-02 (行836-842) | ○ |
| C-22 | isEmail()でバリデーション | E-02 (行688-692) | ○ |
| C-23 | OTCは6桁の数字コード | E-01テンプレート参照（表示形式からの推測） | ○ |
| C-24 | リトライ処理なし | **根拠なし**（コード上で明示的なリトライがないことの確認が必要） | △ |
| C-25 | OTC検証時の5分ウィンドウ | E-02 (行814-821) createHashFromOTCAndToken参照 | ○ |

## 4) 不足情報（Unknown / Missing）
- **リトライ仕様の明確な根拠**
  - コード上でリトライ処理がないことを確認したが、設定ファイルやメール送信基盤（GhostMailer）側でのリトライ有無は未確認
  - 候補：GhostMailer実装 / nodemailer設定 / メールプロバイダー設定

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: テンプレート変数、件名、本文構造
- **0（低リスク）**: APIエンドポイント、トリガー条件
- **1（中リスク）**: リトライ仕様（根拠不十分だが機能影響は小）
- **0（低リスク）**: セキュリティ考慮事項（コードで確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] C-24（リトライ処理なし）の妥当性をGhostMailer実装で確認
- [ ] OTCの桁数・形式がderiveOTC実装と一致するか確認
- [ ] トークン有効期限（24時間）の設定箇所を確認
- [ ] 本番環境でのメール送信成功率・エラーハンドリングを確認
