---
generated_at: 2026-01-29 13:45:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-コメント報告通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/comments/comments-service-emails.js` - メインサービス実装
- E-02: `ghost/core/core/server/services/comments/comments-service-email-renderer.js` - レンダラー実装
- E-03: `ghost/core/core/server/services/comments/email-templates/report.hbs` - HTMLテンプレート
- E-04: 通知一覧.csv - 通知定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コメント報告時にオーナーへメール通知 | E-01 (行146-193), E-04 | ○ |
| C-02 | 件名は「A comment has been reported on your post」 | E-01 (行153) | ○ |
| C-03 | オーナーのみに送信（models.User.getOwnerUser()） | E-01 (行149, 152) | ○ |
| C-04 | commentModerationEnabled = labs.isSet('commentModeration') | E-01 (行157) | ○ |
| C-05 | commentModerationEnabled時はmoderationUrl設定 | E-01 (行182) | ○ |
| C-06 | moderationUrlは/comments/?id=is:{commentId}形式 | E-01 (行182) | ○ |
| C-07 | コメント投稿者名がない場合は'Anonymous' | E-01 (行155) | ○ |
| C-08 | htmlToPlaintext.comment()でテキスト変換 | E-01 (行166) | ○ |
| C-09 | reporter表示名はnameあり時「{name} ({email})」 | E-01 (行171) | ○ |
| C-10 | reporter表示名はnameなし時「{email}」のみ | E-01 (行171) | ○ |
| C-11 | templateDataにreporterName, reporterEmail, reporter含む | E-01 (行169-171) | ○ |
| C-12 | templateDataにmemberName, memberEmail含む | E-01 (行173-174) | ○ |
| C-13 | staffUrlは/settings/staff/{slug}/email-notifications | E-01 (行180) | ○ |
| C-14 | report.hbsでレンダリング | E-01 (行185) | ○ |
| C-15 | preheaderに報告者情報表示 | E-03 (行109) | ○ |
| C-16 | commentModerationEnabled時は「Review comment」ボタン | E-03 (行155-156) | ○ |
| C-17 | commentModerationEnabled=false時は「View comment」ボタン | E-03 (行157-158) | ○ |
| C-18 | commentModerationEnabled=false時は削除案内メッセージ表示 | E-03 (行119) | ○ |
| C-19 | commentHtmlは三重中括弧でエスケープなし出力 | E-03 (行142) | ○ |
| C-20 | memberInitials, memberName, memberExpertise表示 | E-03 (行129, 133-134) | ○ |
| C-21 | commentDateはD MMM YYYY形式 | E-01 (行167) | ○ |
| C-22 | フッターにsiteDomain, toEmail表示 | E-03 (行176) | ○ |
| C-23 | 「Manage your email preferences」リンク表示 | E-03 (行181) | ○ |
| C-24 | sendMail()でforceTextContent: true設定 | E-01 (行221) | ○ |
| C-25 | Post取得時にwithRelated: ['authors']指定 | E-01 (行147) | ○ |
| C-26 | commentTextにプレーンテキスト版含む | E-01 (行166) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主要な主張に対して根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: テンプレート構造、変数（コードで確認済み）
- **0（低リスク）**: オーナー取得ロジック
- **0（低リスク）**: commentModeration条件分岐

## 6) レビュアーチェックリスト（最小）
- [ ] CommentReportedEventのイベントハンドラー登録を確認
- [ ] report.txt.jsのテキストテンプレート実装を確認
- [ ] getOwnerUser()の実装を確認（Owner roleの定義）
- [ ] commentModeration labsフラグの有効化条件を確認
