---
generated_at: 2026-01-29 10:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：11-無料会員サインアップ通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/staff/staff-service-emails.js` 23-66行目 - notifyFreeMemberSignupメソッド
- E-02: `ghost/core/core/server/services/staff/staff-service.js` 140-148行目 - MemberCreatedEventサブスクリプション
- E-03: `ghost/core/core/server/services/staff/staff-service.js` 97-111行目 - handleEventの無料会員処理
- E-04: `ghost/core/core/server/models/user.js` 497-517行目 - getEmailAlertUsersメソッド
- E-05: `ghost/core/core/server/models/user.js` 62-76行目 - usersモデルのdefaults
- E-06: `ghost/core/core/server/services/staff/email-templates/new-free-signup.hbs` - HTMLテンプレート
- E-07: `ghost/core/core/server/services/staff/email-templates/new-free-signup.txt.js` - テキストテンプレート
- E-08: `ghost/core/core/server/services/staff/staff-service-emails.js` 328-339行目 - getMemberDataメソッド
- E-09: `ghost/core/core/server/services/staff/staff-service-emails.js` 431-433行目 - fromEmailAddressプロパティ
- E-10: `ghost/core/core/server/services/staff/staff-service-emails.js` 441-452行目 - sendMailメソッド

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MemberCreatedEventでトリガーされる | E-02 | ○ |
| C-02 | member.status === 'free'の場合のみ送信 | E-03 | ○ |
| C-03 | ソースがapi/memberの場合のみ送信 | E-03 (86-88行目) | ○ |
| C-04 | getEmailAlertUsers('free-signup')で対象取得 | E-01 (26行目), E-04 | ○ |
| C-05 | free_member_signup_notification:trueでフィルター | E-04 (501-502行目), E-05 (68行目) | ○ |
| C-06 | status:activeでフィルター | E-04 (500行目) | ○ |
| C-07 | 件名に絵文字が含まれる | E-01 (32行目) | ○ |
| C-08 | 件名に会員名が含まれる | E-01 (32行目) | ○ |
| C-09 | memberData.nameは名前またはメール | E-08 (329行目) | ○ |
| C-10 | アトリビューション情報を取得 | E-03 (99-107行目) | ○ |
| C-11 | homepageをHomepageに変換 | E-01 (36-38行目) | ○ |
| C-12 | staffUrlを生成 | E-01 (40行目) | ○ |
| C-13 | HTMLテンプレートはnew-free-signup.hbs | E-01 (57行目), E-06 | ○ |
| C-14 | テキストテンプレートはnew-free-signup.txt.js | E-01 (57行目), E-07 | ○ |
| C-15 | siteIconUrlを含む | E-01 (48行目), E-06 (29-33行目) | ○ |
| C-16 | accentColorを使用 | E-01 (51行目), E-06 (64行目) | ○ |
| C-17 | 各ユーザーに個別送信 | E-01 (28-65行目のforループ) | ○ |
| C-18 | 送信元はsettingsHelpersから取得 | E-09 | ○ |
| C-19 | forceTextContent: trueで送信 | E-10 (448行目) | ○ |
| C-20 | 開発環境ではログ出力 | E-10 (442-444行目) | ○ |
| C-21 | referrerSourceを表示 | E-01 (46行目), E-06 (46-53行目) | ○ |
| C-22 | attributionTitleを表示 | E-01 (43-44行目), E-06 (49-52行目) | ○ |
| C-23 | 会員詳細へのリンクを含む | E-08 (334行目), E-06 (64行目) | ○ |
| C-24 | 登録日をフォーマット | E-08 (337行目) | ○ |
| C-25 | geolocationから国を取得 | E-08 (336行目), E-01 (341-353行目 getGeolocationData) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし - 全ての主張にソースコードからの根拠が確認できた

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードで確認できる

## 6) レビュアーチェックリスト（最小）

- [ ] 通知対象ユーザーのフィルター条件が正しいか（E-04参照）
- [ ] テンプレート変数がすべて正しくマッピングされているか（E-01, E-06, E-07参照）
- [ ] エラーハンドリングの記述が実装と一致しているか（E-02 try-catch参照）
