---
generated_at: 2026-01-29 10:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-有料サブスクリプション開始通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/staff/staff-service-emails.js` 68-126行目 - notifyPaidSubscriptionStartedメソッド
- E-02: `ghost/core/core/server/services/staff/staff-service.js` 150-157行目 - SubscriptionActivatedEventサブスクリプション
- E-03: `ghost/core/core/server/services/staff/staff-service.js` 112-129行目 - handleEventの有料サブスクリプション処理
- E-04: `ghost/core/core/server/models/user.js` 503-504行目 - paid-startedフィルター
- E-05: `ghost/core/core/server/services/staff/email-templates/new-paid-started.hbs` - HTMLテンプレート
- E-06: `ghost/core/core/server/services/staff/staff-service-emails.js` 389-418行目 - getOfferDataメソッド
- E-07: `ghost/core/core/server/services/staff/staff-service-emails.js` 356-369行目 - getFormattedAmountメソッド
- E-08: `ghost/core/core/server/services/staff/staff-service.js` 31-63行目 - getSerializedData

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SubscriptionActivatedEventでトリガー | E-02 | ○ |
| C-02 | ソースがapi/memberの場合のみ | E-03 (86-88行目) | ○ |
| C-03 | getEmailAlertUsers('paid-started')で対象取得 | E-01 (69行目), E-04 | ○ |
| C-04 | paid_subscription_started_notification:trueでフィルター | E-04 | ○ |
| C-05 | 件名に絵文字が含まれる | E-01 (75行目) | ○ |
| C-06 | ティア情報を含む | E-01 (80-83行目), E-05 (46-47行目) | ○ |
| C-07 | オファー情報を含む（条件付き） | E-01 (89行目), E-05 (48-51行目) | ○ |
| C-08 | getOfferDataでオファー詳細計算 | E-06 | ○ |
| C-09 | percent/fixed/trialの3タイプ対応 | E-06 (404-411行目) | ○ |
| C-10 | duration: once/repeating/forever/trial対応 | E-06 (395-403行目) | ○ |
| C-11 | 金額はセント単位から変換 | E-01 (77行目), E-07 (371-378行目 getAmount) | ○ |
| C-12 | Intl.NumberFormatで金額フォーマット | E-07 | ○ |
| C-13 | subscriptionData.startedOnを含む | E-01 (85-87行目) | ○ |
| C-14 | アトリビューション情報取得 | E-03 (113-119行目) | ○ |
| C-15 | homepageをHomepageに変換 | E-01 (92-95行目) | ○ |
| C-16 | member/tier/subscription/offerをシリアライズ | E-08 | ○ |
| C-17 | テンプレートはnew-paid-started | E-01 (117行目) | ○ |
| C-18 | accentColorでオファー詳細を装飾 | E-05 (50行目) | ○ |
| C-19 | referrerSourceを表示 | E-01 (103行目), E-05 (52-59行目) | ○ |
| C-20 | 会員詳細へのリンク | E-05 (70行目) | ○ |
| C-21 | siteIconUrlを条件付きで表示 | E-05 (29-33行目) | ○ |
| C-22 | staffUrlで通知設定変更リンク | E-01 (97行目), E-05 (105行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし - 全ての主張にソースコードからの根拠が確認できた

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードで確認できる

## 6) レビュアーチェックリスト（最小）

- [ ] オファー計算ロジックが正しく記述されているか（E-06参照）
- [ ] 金額フォーマットの通貨処理が正しいか（E-07参照）
- [ ] サブスクリプションデータのシリアライズ構造が正確か（E-08参照）
