---
generated_at: 2026-01-29 10:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-サブスクリプションキャンセル通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/staff/staff-service-emails.js` 128-177行目 - notifyPaidSubscriptionCanceledメソッド
- E-02: `ghost/core/core/server/services/staff/staff-service.js` 159-166行目 - SubscriptionCancelledEventサブスクリプション
- E-03: `ghost/core/core/server/services/staff/staff-service.js` 130-137行目 - handleEventのキャンセル処理
- E-04: `ghost/core/core/server/models/user.js` 505-506行目 - paid-canceledフィルター
- E-05: `ghost/core/core/server/models/user.js` 70行目 - デフォルト値false
- E-06: `ghost/core/core/server/services/staff/email-templates/new-paid-cancellation.hbs` - HTMLテンプレート
- E-07: `ghost/core/core/server/services/staff/staff-service.js` 47-48行目 - cancelAt, cancellationReasonのシリアライズ

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SubscriptionCancelledEventでトリガー | E-02 | ○ |
| C-02 | ソースがapi/memberの場合のみ | E-03 (86-88行目) | ○ |
| C-03 | getEmailAlertUsers('paid-canceled')で対象取得 | E-01 (129行目), E-04 | ○ |
| C-04 | paid_subscription_canceled_notification:trueでフィルター | E-04, E-05 | ○ |
| C-05 | デフォルト値はfalse | E-05 | ○ |
| C-06 | 件名に警告絵文字を使用 | E-01 (134行目) | ○ |
| C-07 | ティア情報を含む | E-01 (140-143行目), E-06 (50-51行目) | ○ |
| C-08 | expiryAtを表示 | E-01 (146行目), E-06 (52-57行目) | ○ |
| C-09 | cancelNowで表示文言を切り替え | E-01 (147行目), E-06 (52-56行目) | ○ |
| C-10 | cancellationReasonを表示（条件付き） | E-01 (149行目), E-06 (58-60行目) | ○ |
| C-11 | canceledAtを含む | E-01 (148行目) | ○ |
| C-12 | イベントデータをスプレッド展開 | E-03 (135行目) | ○ |
| C-13 | cancellation_reasonはsubscriptionから取得 | E-07 | ○ |
| C-14 | current_period_endをcancelAtとして使用 | E-07 | ○ |
| C-15 | 金額フォーマットを実行 | E-01 (136-139行目) | ○ |
| C-16 | テンプレートはnew-paid-cancellation | E-01 (168行目) | ○ |
| C-17 | 会員詳細へのリンク | E-06 (71行目) | ○ |
| C-18 | siteIconUrlを条件付きで表示 | E-06 (33-37行目) | ○ |
| C-19 | staffUrlで通知設定変更リンク | E-01 (152行目), E-06 (105行目) | ○ |
| C-20 | プレビューにcancellationReasonを表示 | E-06 (17-24行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし - 全ての主張にソースコードからの根拠が確認できた

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードで確認できる

## 6) レビュアーチェックリスト（最小）

- [ ] デフォルトでfalseの設定が正しく記載されているか（E-05参照）
- [ ] cancelNow/expiryAt/canceledAtの違いが明確か（E-01参照）
- [ ] cancellationReasonの取得元が正しいか（E-07参照）
