---
generated_at: 2026-01-29 10:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-マイルストーン達成通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/staff/staff-service-emails.js` 206-261行目 - notifyMilestoneReceivedメソッド
- E-02: `ghost/core/core/server/services/staff/staff-service.js` 168-176行目 - MilestoneCreatedEventサブスクリプション
- E-03: `ghost/core/core/server/services/staff/staff-service.js` 81-84行目 - handleEventのマイルストーン処理
- E-04: `ghost/core/core/server/models/user.js` 509-510行目 - milestone-receivedフィルター
- E-05: `ghost/core/core/server/models/user.js` 73行目 - milestone_notificationsデフォルト値true
- E-06: `ghost/core/core/server/services/staff/milestone-email-config.js` - マイルストーン設定
- E-07: `ghost/core/core/server/services/staff/email-templates/new-milestone-received.hbs` - HTMLテンプレート

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MilestoneCreatedEventでトリガー | E-02, E-03 | ○ |
| C-02 | emailSentAtが必要 | E-01 (207行目) | ○ |
| C-03 | meta.reasonが存在すると送信しない | E-01 (207行目) | ○ |
| C-04 | getEmailAlertUsers('milestone-received')で対象取得 | E-01 (225行目), E-04 | ○ |
| C-05 | milestone_notifications:trueでフィルター（デフォルトtrue） | E-04, E-05 | ○ |
| C-06 | milestone-email-configから設定読み込み | E-01 (214行目), E-06 | ○ |
| C-07 | type + valueで設定を取得 | E-01 (216行目) | ○ |
| C-08 | emailDataが無効な場合は警告ログ | E-01 (218-222行目) | ○ |
| C-09 | Promise.allSettledで並列送信 | E-01 (254行目) | ○ |
| C-10 | 失敗はログに記録して継続 | E-01 (256-260行目) | ○ |
| C-11 | ARRマイルストーン: $100, $1000, ... $1m | E-06 (23-84行目) | ○ |
| C-12 | 会員数マイルストーン: 100, 1000, ... 1m | E-06 (85-203行目) | ○ |
| C-13 | 画像はstatic.ghost.orgから参照 | E-06 (27-28行目等) | ○ |
| C-14 | subject, heading, content, ctaTextを含む | E-06 (10-17行目) | ○ |
| C-15 | Ghostロゴアニメーション画像 | E-07 (49行目) | ○ |
| C-16 | getFormattedAmountで値をフォーマット | E-01 (213行目) | ○ |
| C-17 | maximumFractionDigits: 0で整数表示 | E-01 (213行目) | ○ |
| C-18 | partial変数でマイルストーン別処理 | E-01 (238行目) | ○ |
| C-19 | adminUrlへのリンク | E-01 (240行目), E-07 (101行目) | ○ |
| C-20 | ソースチェックなしで実行 | E-03 (82-84行目) | ○ |
| C-21 | 1000 True Fans理論への言及（1000会員） | E-06 (105-106行目) | ○ |
| C-22 | Top X%のクリエイターへの言及 | E-06 (168行目, 182行目, 194行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし - 全ての主張にソースコードからの根拠が確認できた

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードで確認できる

## 6) レビュアーチェックリスト（最小）

- [ ] マイルストーン設定値がすべて網羅されているか（E-06参照）
- [ ] emailSentAt/meta.reasonの条件が正しいか（E-01参照）
- [ ] Promise.allSettledのエラーハンドリングが正しく記載されているか（E-01参照）
