---
generated_at: 2026-01-29 10:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-ドネーション受領通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/staff/staff-service-emails.js` 270-323行目 - notifyDonationReceivedメソッド
- E-02: `ghost/core/core/server/models/user.js` 511-512行目 - donationフィルター
- E-03: `ghost/core/core/server/models/user.js` 74行目 - donation_notificationsデフォルト値true
- E-04: `ghost/core/core/server/services/staff/email-templates/donation.hbs` - HTMLテンプレート

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | getEmailAlertUsers('donation')で対象取得 | E-01 (272行目), E-02 | ○ |
| C-02 | donation_notifications:trueでフィルター（デフォルトtrue） | E-02, E-03 | ○ |
| C-03 | 金額はamount/100で計算 | E-01 (273行目) | ○ |
| C-04 | 件名にお金絵文字を使用 | E-01 (275行目) | ○ |
| C-05 | 件名にname ?? emailを使用 | E-01 (275行目) | ○ |
| C-06 | memberIdがある場合のみmemberData生成 | E-01 (276-280行目) | ○ |
| C-07 | Promise.allSettledで並列送信 | E-01 (316行目) | ○ |
| C-08 | 失敗はログに記録して継続 | E-01 (318-322行目) | ○ |
| C-09 | 見出しは「Cha-ching! You received a tip.」 | E-04 (31行目) | ○ |
| C-10 | memberDataがある場合Viewリンク表示 | E-04 (40行目) | ○ |
| C-11 | donationMessageを表示 | E-04 (43-45行目) | ○ |
| C-12 | メッセージ有無でCTAボタンが変化 | E-04 (56-76行目) | ○ |
| C-13 | メッセージありでReply | E-04 (56-65行目) | ○ |
| C-14 | メッセージなしでSay thanks | E-04 (66-76行目) | ○ |
| C-15 | mailto:リンクを使用 | E-04 (61行目, 71行目) | ○ |
| C-16 | accentColorを使用 | E-01 (303行目), E-04 (60行目, 70行目) | ○ |
| C-17 | siteIconUrlを条件付きで表示 | E-04 (24-28行目) | ○ |
| C-18 | staffUrlで通知設定変更リンク | E-01 (295行目), E-04 (99行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし - 全ての主張にソースコードからの根拠が確認できた

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードで確認できる

## 6) レビュアーチェックリスト（最小）

- [ ] memberIdの有無による分岐が正しく記載されているか（E-01参照）
- [ ] メッセージ有無によるCTAボタンの切り替えが正しいか（E-04参照）
- [ ] 金額計算（/100）が正しく記載されているか（E-01参照）
