---
generated_at: 2026-01-29 10:25:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-メンションレポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/mentions-email-report/service.js` - サービス初期化
- E-02: `ghost/core/core/server/services/mentions-email-report/mention-email-report-job.js` - レポートジョブ
- E-03: `ghost/core/core/server/models/user.js` 507-508行目 - mention-receivedフィルター
- E-04: `ghost/core/core/server/models/user.js` 71行目 - mention_notificationsデフォルト値true
- E-05: `ghost/core/core/server/services/staff/email-templates/mention-report.hbs` - HTMLテンプレート

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | スケジュールジョブで毎時チェック | E-01 (155-163行目) | ○ |
| C-02 | ランダムな分・秒でスケジュール | E-01 (155-156行目) | ○ |
| C-03 | 24時間間隔でレポート送信 | E-02 (42-44行目) | ○ |
| C-04 | 起動時にもチェック実行 | E-01 (153行目) | ○ |
| C-05 | labs.webmentionsが有効な場合のみ | E-01 (147行目) | ○ |
| C-06 | getEmailAlertUsers('mention-received')で対象取得 | E-01 (26行目), E-03 | ○ |
| C-07 | mention_notifications:trueでフィルター（デフォルトtrue） | E-03, E-04 | ○ |
| C-08 | 前回レポート日時をsettingsから取得 | E-01 (98-109行目) | ○ |
| C-09 | 設定値がNaNの場合は1日前をデフォルト | E-01 (103-106行目) | ○ |
| C-10 | メンション情報を変換 | E-02 (48-58行目) | ○ |
| C-11 | メンションなしなら0を返して終了 | E-02 (61-63行目) | ○ |
| C-12 | 重複ソースURLを除去 | E-01 (67-68行目, 85-86行目) | ○ |
| C-13 | 最大5件表示 | E-05 (29行目 limit mentions 5) | ○ |
| C-14 | hasMoreMentionsで5件以上を判定 | E-01 (74行目) | ○ |
| C-15 | 件名を動的生成（1件/2件/3件以上） | E-01 (41-57行目) | ○ |
| C-16 | uniqueSourceSiteTitlesでカウント | E-01 (42-44行目) | ○ |
| C-17 | レポート送信後に日時を更新 | E-02 (75行目) | ○ |
| C-18 | models.Settings.editで更新 | E-01 (111-115行目) | ○ |
| C-19 | staffService.api.emails.renderHTML使用 | E-01 (71-75行目, 89-92行目) | ○ |
| C-20 | sourceUrl/targetUrl/等のフィールド | E-02 (49-57行目) | ○ |
| C-21 | 管理画面メンションページへのリンク | E-05 (94行目) | ○ |
| C-22 | ファビコン・画像を表示 | E-05 (37-45行目) | ○ |
| C-23 | staffUrlで通知設定変更リンク | E-05 (116行目) | ○ |
| C-24 | GhostMailerで送信 | E-01 (119-129行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし - 全ての主張にソースコードからの根拠が確認できた

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードで確認できる

## 6) レビュアーチェックリスト（最小）

- [ ] 24時間間隔のチェックロジックが正しいか（E-02参照）
- [ ] 件名の動的生成ロジックが正しいか（E-01参照）
- [ ] 重複除去ロジックが正しく記載されているか（E-01参照）
