---
generated_at: 2026-01-29 10:30:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-レコメンデーション受信通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/recommendations/service/incoming-recommendation-service.ts` - メインサービス
- E-02: `ghost/core/core/server/services/recommendations/service/incoming-recommendation-email-renderer.ts` - レンダラー
- E-03: `ghost/core/core/server/models/user.js` 513-514行目 - recommendation-receivedフィルター
- E-04: `ghost/core/core/server/models/user.js` 72行目 - recommendation_notificationsデフォルト値true
- E-05: `ghost/core/core/server/services/staff/email-templates/recommendation-received.hbs` - HTMLテンプレート

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IncomingRecommendation型定義 | E-01 (7-15行目) | ○ |
| C-02 | /.well-known/recommendations.jsonでフィルター | E-01 (95-97行目 getMentionFilter) | ○ |
| C-03 | URLから.well-known/recommendations.jsonを除去 | E-01 (109行目) | ○ |
| C-04 | 相互推薦をチェック（readRecommendationByUrl） | E-01 (112-113行目) | ○ |
| C-05 | recommendingBackフラグを設定 | E-01 (113行目) | ○ |
| C-06 | sendRecommendationEmailでメール送信 | E-01 (130-144行目) | ○ |
| C-07 | mentionがnullなら早期リターン | E-01 (132-134行目) | ○ |
| C-08 | 件名に絵文字と推薦元タイトル | E-02 (20-22行目) | ○ |
| C-09 | staffService.api.emails.renderHTML使用 | E-02 (24-28行目) | ○ |
| C-10 | recommendation_notifications:trueでフィルター（デフォルトtrue） | E-03, E-04 | ○ |
| C-11 | recommendingBackで見出し分岐 | E-05 (31-35行目) | ○ |
| C-12 | 相互推薦時「recommending you back」 | E-05 (32行目) | ○ |
| C-13 | 非相互推薦時「recommending you to their audience」 | E-05 (34行目) | ○ |
| C-14 | 非相互推薦時に説明文表示 | E-05 (35行目) | ○ |
| C-15 | 推薦元情報のカード表示 | E-05 (39-56行目) | ○ |
| C-16 | ファビコン・画像を条件付き表示 | E-05 (43行目, 51-53行目) | ○ |
| C-17 | recommendingBack=trueでView recommendations | E-05 (100行目) | ○ |
| C-18 | recommendingBack=falseでRecommend back | E-05 (102行目) | ○ |
| C-19 | encodeURIComponentでURLエンコード | E-05 (102行目) | ○ |
| C-20 | TypeScriptで実装 | E-01, E-02 (ファイル拡張子.ts) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし - 全ての主張にソースコードからの根拠が確認できた

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードで確認できる

## 6) レビュアーチェックリスト（最小）

- [ ] recommendingBackフラグの判定ロジックが正しいか（E-01参照）
- [ ] テンプレートの分岐条件が正しく記載されているか（E-05参照）
- [ ] URLエンコーディングの使用箇所が正しいか（E-05参照）
