---
generated_at: 2026-01-29 10:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-スタッフ招待メール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/invites/invites.js` - 招待サービス全体

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 既存招待があれば削除 | E-01 (26-33行目) | ○ |
| C-02 | InviteModel.addで新規作成 | E-01 (35行目) | ○ |
| C-03 | adminUrlを取得 | E-01 (40行目) | ○ |
| C-04 | 招待者名有無でemailData分岐 | E-01 (42-61行目) | ○ |
| C-05 | resetLinkをBase64エンコードで生成 | E-01 (47, 56行目) | ○ |
| C-06 | security.url.encodeBase64使用 | E-01 (47行目) | ○ |
| C-07 | invite-userテンプレート使用（名前あり） | E-01 (51行目) | ○ |
| C-08 | invite-user-by-api-keyテンプレート使用（名前なし） | E-01 (60行目) | ○ |
| C-09 | デフォルトドメインのメールアドレス使用（API経由） | E-01 (55行目) | ○ |
| C-10 | 件名にinvitedByName使用（条件付き） | E-01 (69-74行目) | ○ |
| C-11 | tplでメッセージテンプレート処理 | E-01 (69-73行目) | ○ |
| C-12 | replyToに招待者メール設定 | E-01 (68行目) | ○ |
| C-13 | api.mail.sendでメール送信 | E-01 (82行目) | ○ |
| C-14 | 送信成功時にステータスを'sent'に更新 | E-01 (85-87行目) | ○ |
| C-15 | EmailErrorの場合はヘルプテキスト追加 | E-01 (93-98行目) | ○ |
| C-16 | logging.warnでエラーログ | E-01 (99行目) | ○ |
| C-17 | Promise.rejectでエラーを返す | E-01 (102行目) | ○ |
| C-18 | messages定義にinvitedByName/invitedByNoName | E-01 (6-7行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし - 全ての主張にソースコードからの根拠が確認できた

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードで確認できる

## 6) レビュアーチェックリスト（最小）

- [ ] 既存招待の削除ロジックが正しいか（E-01参照）
- [ ] テンプレート選択の条件が正しいか（E-01参照）
- [ ] エラーハンドリングの記述が正しいか（E-01参照）
