---
generated_at: 2026-01-29 10:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-パスワードリセットメール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/auth/passwordreset.js` - パスワードリセットサービス全体

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | generateTokenでトークン生成 | E-01 (36-64行目) | ○ |
| C-02 | settingsAPIからdb_hash取得 | E-01 (41-43行目) | ○ |
| C-03 | User.getByEmailでユーザー検索 | E-01 (45行目) | ○ |
| C-04 | ユーザー不在でNotFoundError | E-01 (48-49行目) | ○ |
| C-05 | トークンに有効期限1日を設定 | E-01 (53行目) | ○ |
| C-06 | トークンにemail, dbHash, password含む | E-01 (52-57行目) | ○ |
| C-07 | sendResetNotificationでメール送信 | E-01 (164-191行目) | ○ |
| C-08 | Base64エンコードでトークン変換 | E-01 (166行目) | ○ |
| C-09 | adminUrl + reset + tokenでURL生成 | E-01 (167行目) | ○ |
| C-10 | reset-passwordテンプレート使用 | E-01 (175行目) | ○ |
| C-11 | mail.utils.generateContentでコンテンツ生成 | E-01 (173-176行目) | ○ |
| C-12 | 件名はReset Password | E-01 (182行目) | ○ |
| C-13 | mailAPI.sendでメール送信 | E-01 (190行目) | ○ |
| C-14 | extractTokenPartsでトークン解析 | E-01 (66-82行目) | ○ |
| C-15 | Base64デコードして解析 | E-01 (67行目) | ○ |
| C-16 | ブルートフォース保護（10回制限） | E-01 (86-91行目) | ○ |
| C-17 | doResetでパスワード変更実行 | E-01 (96-162行目) | ○ |
| C-18 | トークン検証（expired/invalid判定） | E-01 (115-138行目) | ○ |
| C-19 | User.changePasswordでパスワード変更 | E-01 (140-144行目) | ○ |
| C-20 | otp.generateで2FAバイパストークン生成 | E-01 (152-154行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし - 全ての主張にソースコードからの根拠が確認できた

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードで確認できる

## 6) レビュアーチェックリスト（最小）

- [ ] トークン生成のパラメータが正しいか（E-01参照）
- [ ] ブルートフォース保護の条件が正しいか（E-01参照）
- [ ] 2FAバイパストークンの用途が正しく記載されているか（E-01参照）
