---
generated_at: 2026-01-29 12:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-会員サインアップメール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/members/emails/signup.js` - サインアップメールHTMLテンプレート
- E-02: `ghost/core/core/server/services/members/members-api/controllers/router-controller.js` - APIコントローラー
- E-03: `ghost/core/core/server/services/members/members-api/members-api.js` - Members APIファクトリー
- E-04: `ghost/core/core/server/services/lib/magic-link/magic-link.js` - MagicLinkクラス
- E-05: 通知一覧.csv - 通知定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 新規会員登録確認メールが送信される | E-01, E-05 | ○ |
| C-02 | 件名は「Complete your sign up to {siteTitle}!」 | E-01 (行9) | ○ |
| C-03 | 既存会員はサインインメールにフォールバック | E-03 (行225-232) | ○ |
| C-04 | emailType='signup'でトリガー | E-02 (行725-726) | ○ |
| C-05 | emailType='subscribe'でも会員不在時はsignup | E-03 (行229-230) | ○ |
| C-06 | セルフサインアップ許可チェックあり | E-02 (行824-834) | ○ |
| C-07 | 招待制限時はエラー「This site is invite-only」 | E-02 (行829-832) | ○ |
| C-08 | 有料限定時はエラー「This site only accepts paid members」 | E-02 (行826-828) | ○ |
| C-09 | ブロックドメインチェックあり | E-02 (行836-842) | ○ |
| C-10 | トークンにname, labels, newsletters, attribution, reqIpが含まれる | E-02 (行846-852) | ○ |
| C-11 | テンプレート変数：siteTitle, email, url, accentColor, siteDomain, siteUrl | E-01 (行1) | ○ |
| C-12 | accentColorのデフォルトは#15212A | E-01 (行1) | ○ |
| C-13 | リンクは24時間で有効期限切れ | E-01 (行138) | ○ |
| C-14 | 「Confirm signup」ボタンがある | E-01 (行130) | ○ |
| C-15 | フッターに「You will not be signed up, and no account will be created」 | E-01 (行153) | ○ |
| C-16 | getMemberDataFromMagicLinkTokenで会員作成 | E-03 (行254-294) | ○ |
| C-17 | type='signup'/'subscribe'以外は会員作成しない | E-03 (行272-277) | ○ |
| C-18 | users.create()で会員レコード作成 | E-03 (行290) | ○ |
| C-19 | ジオロケーション取得にreqIpを使用 | E-03 (行279-288) | ○ |
| C-20 | sniperLinksがレスポンスに含まれる | E-02 (行734-741) | ○ |
| C-21 | ハニーポットフィールドでボット対策 | E-02 (行702-709) | ○ |
| C-22 | メールアドレス正規化を実施 | E-02 (行694-700) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主要な主張に対して根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: すべての主張に根拠あり
- **0（低リスク）**: テンプレート構造、変数
- **0（低リスク）**: トリガー条件、フォールバック動作

## 6) レビュアーチェックリスト（最小）
- [ ] サインアップ完了後の会員作成フローが想定通りか確認
- [ ] newsletters設定がトークンに正しく含まれることを確認
- [ ] attribution情報の取得と保存フローを確認
