---
generated_at: 2026-01-29 10:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-ニュースレターメールアドレス検証

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/newsletters/newsletters-service.js` - ニュースレターサービス全体
- E-02: `ghost/core/core/server/services/newsletters/emails/verify-email.js` - HTMLメールテンプレート
- E-03: `ghost/core/core/server/services/lib/magic-link/magic-link.js` - MagicLinkサービス

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | prepAttrsForEmailVerificationで検証準備 | E-01 (265-326行目) | ○ |
| C-02 | emailPropertiesでsender_email定義 | E-01 (268-270行目) | ○ |
| C-03 | sender_reply_toがnewsletter/support以外で追加 | E-01 (272-276行目) | ○ |
| C-04 | emailAddressService.service.validateで検証 | E-01 (287行目) | ○ |
| C-05 | verificationEmailRequired時にemailsToVerifyに追加 | E-01 (295-301行目) | ○ |
| C-06 | cleanedAttrsから属性を削除 | E-01 (300行目) | ○ |
| C-07 | respondWithEmailVerificationでメール送信 | E-01 (331-342行目) | ○ |
| C-08 | sendEmailVerificationMagicLinkで実際の送信 | E-01 (347-367行目) | ○ |
| C-09 | defaultFromAddressを使用 | E-01 (348行目) | ○ |
| C-10 | 件名はVerify email address | E-01 (358行目) | ○ |
| C-11 | ghostMailer.sendでメール送信 | E-01 (362行目) | ○ |
| C-12 | magicLinkService.sendMagicLinkを呼び出し | E-01 (366行目) | ○ |
| C-13 | tokenDataにid, property, value含む | E-01 (366行目) | ○ |
| C-14 | getSigninURLでadminUrl + hash生成 | E-01 (75-80行目) | ○ |
| C-15 | ハッシュは/settings/newsletters/?verifyEmail=形式 | E-01 (78行目) | ○ |
| C-16 | MagicLinkでtokenProvider.create呼び出し | E-03 (81行目) | ○ |
| C-17 | transporter.sendMailでメール送信 | E-03 (97-102行目) | ○ |
| C-18 | verifyPropertyUpdateでトークンからデータ取得 | E-01 (245-258行目) | ○ |
| C-19 | getDataFromTokenでトークン検証 | E-01 (246行目) | ○ |
| C-20 | NewsletterModel.editでプロパティ更新 | E-01 (252行目) | ○ |
| C-21 | verify-email.jsでHTMLテンプレート生成 | E-02 (1-172行目) | ○ |
| C-22 | 有効期限24時間のメッセージ | E-02 (136行目), E-01 (64行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし - 全ての主張にソースコードからの根拠が確認できた

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードで確認できる

## 6) レビュアーチェックリスト（最小）

- [ ] emailPropertiesの定義が正しいか（E-01参照）
- [ ] 検証条件（verificationEmailRequired）の判定が正しいか（E-01参照）
- [ ] トークンデータ構造が正しいか（E-01参照）
- [ ] 検証URL形式が正しいか（E-01参照）
