---
generated_at: 2026-01-29 22:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：21-アップデートチェック重要アラート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **通知グループフィルタリング機能**：コードで確認済みだが動作確認推奨
  2. **メール送信エラー時の継続処理**：try-catch構造は確認済み
  3. **更新チェックサービスURL**：デフォルト設定ファイルでの確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/services/update-check/update-check-service.js` 343-358行目（アラートタイプ判定とメール送信）
- E-02: `ghost/core/core/server/services/update-check/update-check-service.js` 318-327行目（管理者ユーザー取得ロジック）
- E-03: `ghost/core/core/server/services/update-check/update-check-service.js` 346-350行目（メール件名とオプション）
- E-04: `ghost/core/core/server/services/update-check/update-check-service.js` 373-391行目（check()メソッド）
- E-05: `ghost/core/core/server/services/update-check/index.js` 75-86行目（ジョブスケジューリング）
- E-06: `ghost/core/core/server/services/update-check/index.js` 28-35行目（環境チェック）
- E-07: `ghost/core/core/server/services/update-check/update-check-service.js` 169-172行目（HTTPタイムアウト設定）
- E-08: `ghost/core/core/server/services/update-check/update-check-service.js` 193-199行目（404レスポンス処理）
- E-09: `ghost/core/core/server/services/update-check/update-check-service.js` 80-96行目（エラー処理）
- E-10: `ghost/core/core/server/services/update-check/update-check-service.js` 63-66行目（次回チェックタイムスタンプ計算）
- E-11: `ghost/core/core/server/services/update-check/update-check-service.js` 218-237行目（レスポンス構造コメント）
- E-12: `ghost/core/core/server/services/update-check/update-check-service.js` 281-298行目（通知グループフィルタリング）
- E-13: `ghost/core/core/server/services/update-check/run-update-check.js` 全体（ワーカースレッド実行）
- E-14: `ghost/core/core/server/data/schema/default-settings/default-settings.json` 19-22行目（notifications設定）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | type:alertの通知がメール送信対象 | E-01 | ○ |
| C-02 | Owner/Administratorロールのユーザーがメール受信者 | E-02 | ○ |
| C-03 | メール件名形式 | E-03 | ○ |
| C-04 | 毎日1回の定期実行 | E-05 | ○ |
| C-05 | development/production環境のみで実行 | E-06 | ○ |
| C-06 | HTTPタイムアウト1000ms | E-07 | ○ |
| C-07 | 404レスポンスは正常終了扱い | E-08 | ○ |
| C-08 | エラー時もnext_update_checkを更新 | E-09 | ○ |
| C-09 | 次回チェックは現在時刻+24時間 | E-10 | ○ |
| C-10 | forceTextContent:trueオプション | E-03 | ○ |
| C-11 | レスポンス構造の説明 | E-11 | ○ |
| C-12 | 通知グループによるフィルタリング | E-12 | ○ |
| C-13 | ワーカースレッドでの実行 | E-13 | ○ |
| C-14 | notifications設定のデフォルト値 | E-14 | ○ |
| C-15 | privacy.useUpdateCheckによるオプトアウト | E-06 | ○ |
| C-16 | status:activeでユーザーをフィルタ | E-02 | ○ |
| C-17 | 管理画面通知も同時に登録 | E-01 (362行目) | ○ |
| C-18 | 更新チェックサービスのURL（updates.ghost.org） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 更新チェックサービスのデフォルトURLについて、コード内でハードコードされた値を確認できなかった
  - 候補：config設定ファイル / 環境変数 / Ghost公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にコードベースから直接根拠が取得できている
- 1: 中リスク - 更新チェックサービスURLの設定箇所の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] メール送信処理のtry-catchによるエラー継続確認（343-358行目）
- [ ] 管理者ロール判定ロジックの正確性確認（roles[0].name参照）
- [ ] 更新チェックサービスURLのデフォルト設定箇所の特定
- [ ] ジョブスケジューリングのランダム時刻生成確認（75-86行目）
