---
generated_at: 2026-01-29 22:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：22-システム通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. **バージョンフィルタリングロジック**：複雑な条件分岐のため動作確認推奨
  2. **自己修復機能の発動条件**：データ破損パターンの理解が必要
  3. **seenBy配列の競合制御**：並行アクセス時の動作確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/services/notifications/notifications.js` 123-135行目（add()デフォルト値）
- E-02: `ghost/core/core/server/services/notifications/notifications.js` 29-48行目（fetchAllNotifications()）
- E-03: `ghost/core/core/server/services/notifications/notifications.js` 72-121行目（browse()メソッド）
- E-04: `ghost/core/core/server/services/notifications/notifications.js` 192-229行目（destroy()メソッド）
- E-05: `ghost/core/core/server/services/notifications/notifications.js` 248-256行目（dangerousDestroyAll()）
- E-06: `ghost/core/core/server/services/notifications/notifications.js` 56-62行目（areNotificationsValid()）
- E-07: `ghost/core/core/server/services/notifications/notifications.js` 64-70行目（wasSeen()）
- E-08: `ghost/core/core/server/services/notifications/notifications.js` 142-150行目（重複チェック）
- E-09: `ghost/core/core/server/services/notifications/notifications.js` 156-161行目（リリース通知削除）
- E-10: `ghost/core/core/server/services/notifications/notifications.js` 203-207行目（NoPermissionError）
- E-11: `ghost/core/core/server/services/notifications/notifications.js` 209-212行目（NotFoundError）
- E-12: `ghost/core/core/server/data/schema/default-settings/default-settings.json` 19-22行目（デフォルト値）
- E-13: `ghost/core/core/server/services/notifications/index.js` 全体（サービス初期化）
- E-14: `ghost/core/core/server/services/notifications/notifications.js` 78-79行目（createdAtVersionフィルタ）
- E-15: `ghost/core/core/server/services/notifications/notifications.js` 87-114行目（レガシー通知フィルタ）
- E-16: `ghost/core/core/server/services/notifications/notifications.js` 9-12行目（エラーメッセージ定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知はsettingsテーブルにJSON配列で保存 | E-02, E-12 | ○ |
| C-02 | デフォルト値: dismissible=true, location=bottom, status=alert | E-01 | ○ |
| C-03 | 重複する通知IDは追加されない | E-08 | ○ |
| C-04 | リリース通知は新規追加時に既存を削除 | E-09 | ○ |
| C-05 | destroy()はseen=trueに設定し実際には削除しない | E-04 | ○ |
| C-06 | dismissible=falseの通知は消去不可 | E-10 | ○ |
| C-07 | 存在しない通知IDでNotFoundError | E-11 | ○ |
| C-08 | areNotificationsValid()でデータ検証 | E-06 | ○ |
| C-09 | 不正データ時はdangerousDestroyAll()で自己修復 | E-02, E-05 | ○ |
| C-10 | seenByによるユーザーごとの閲覧状態管理 | E-07 | ○ |
| C-11 | createdAtVersionでバージョンフィルタ | E-14 | ○ |
| C-12 | レガシー通知のバージョン検出（正規表現） | E-15 | ○ |
| C-13 | Notificationsクラスのシングルトン公開 | E-13 | ○ |
| C-14 | notificationsデフォルト値は空配列 | E-12 | ○ |
| C-15 | ObjectId()でID自動生成 | E-01 (128行目) | ○ |
| C-16 | ghostVersion.fullでcreatedAtVersion自動設定 | E-01 (129行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。主要な機能はすべてソースコードから根拠が取得できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にコードベースから直接根拠が取得できている
- 1: 中リスク - バージョンフィルタリングの正規表現ロジックは複雑なため動作確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] wasSeen()のseenBy配列参照ロジック確認（64-70行目）
- [ ] リリース通知のバージョン比較正規表現確認（87-114行目）
- [ ] 自己修復機能dangerousDestroyAll()の発動条件確認
- [ ] settingsCacheとSettingsModelの整合性確認
