---
generated_at: 2026-01-29 22:10:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：23-投稿公開Slack通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. **説明文抽出ロジック**：HTML処理と文分割の正確性確認推奨
  2. **会員限定コンテンツ除外**：`<!--members-only-->`の処理確認
  3. **Slack API互換性**：attachments形式のバージョン互換性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/services/slack.js` 29-37行目（getSlackSettings()）
- E-02: `ghost/core/core/server/services/slack.js` 19-27行目（defaultPostSlugs配列）
- E-03: `ghost/core/core/server/services/slack.js` 48-56行目（ping()関数の初期化）
- E-04: `ghost/core/core/server/services/slack.js` 63-86行目（説明文生成ロジック）
- E-05: `ghost/core/core/server/services/slack.js` 92-105行目（送信条件チェック）
- E-06: `ghost/core/core/server/services/slack.js` 108-156行目（slackData構築）
- E-07: `ghost/core/core/server/services/slack.js` 158-170行目（HTTPリクエストとエラー処理）
- E-08: `ghost/core/core/server/services/slack.js` 173-184行目（slackListener()）
- E-09: `ghost/core/core/server/services/slack.js` 186-190行目（slackTestPing()）
- E-10: `ghost/core/core/server/services/slack.js` 192-200行目（listen()）
- E-11: `ghost/core/core/server/services/slack.js` 44-46行目（hasPostProperties()）
- E-12: `ghost/core/core/server/services/slack.js` 14-17行目（エラーメッセージ定義）
- E-13: `ghost/core/core/server/services/slack.js` 93行目（usernameデフォルト値）
- E-14: `ghost/core/core/server/services/slack.js` 66-67行目（members-onlyコンテンツ除外）
- E-15: `ghost/core/core/server/services/slack.js` 123行目（attachmentsカラーコード）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | slack_url, slack_usernameをsettingsCacheから取得 | E-01 | ○ |
| C-02 | デフォルトスラッグの投稿は通知対象外 | E-02, E-05 | ○ |
| C-03 | post.publishedイベントでトリガー | E-10 | ○ |
| C-04 | type=pageの場合は送信しない | E-05 (95-97行目) | ○ |
| C-05 | importingフラグがtrueの場合はスキップ | E-08 (176-178行目) | ○ |
| C-06 | custom_excerptが優先、なければhtml本文から抽出 | E-04 | ○ |
| C-07 | 最初の3文を説明文として使用 | E-04 (76-80行目) | ○ |
| C-08 | 会員限定コンテンツを除外 | E-14 | ○ |
| C-09 | デフォルトusernameは「Ghost」 | E-13 | ○ |
| C-10 | attachmentsカラーは#008952 | E-15 | ○ |
| C-11 | エラー時はログ出力のみで処理継続 | E-07 | ○ |
| C-12 | slack.testイベントでテスト送信可能 | E-09, E-10 | ○ |
| C-13 | unfurl_links: trueを設定 | E-06 (112行目) | ○ |
| C-14 | hasPostPropertiesでhtml/title/slugを確認 | E-11 | ○ |
| C-15 | 重複リスナー登録を防止 | E-10 (193, 197行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。主要な機能はすべてソースコードから根拠が取得できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にコードベースから直接根拠が取得できている
- 1: 中リスク - 説明文抽出の正規表現とHTMLパース処理は複雑なため動作確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] getSlackSettings()の戻り値確認（29-37行目）
- [ ] defaultPostSlugsの完全なリスト確認（19-27行目）
- [ ] 説明文抽出の文分割ロジック確認（76-80行目）
- [ ] members-onlyコメント位置の検出確認（66-67行目）
- [ ] Slack Webhook APIとの互換性確認（attachments形式）
