---
generated_at: 2026-01-29 22:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：24-マイルストーンSlack通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. **hostSettings取得ロジック**：Ghost(Pro)環境依存の設定
  2. **minThreshold比較演算子**：`<`（未満）の条件確認
  3. **Intl.NumberFormat通貨フォーマット**：ロケール依存の挙動確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/services/slack-notifications/slack-notifications.js` 57-60行目（skipped/initial判定）
- E-02: `ghost/core/core/server/services/slack-notifications/slack-notifications.js` 136-145行目（slackData構築）
- E-03: `ghost/core/core/server/services/slack-notifications/slack-notifications.js` 157-180行目（send()メソッド）
- E-04: `ghost/core/core/server/services/slack-notifications/slack-notifications.js` 175-177行目（リトライ設定）
- E-05: `ghost/core/core/server/services/slack-notifications/slack-notifications.js` 189-199行目（金額フォーマット）
- E-06: `ghost/core/core/server/services/slack-notifications/slack-notifications.js` 206-208行目（日付フォーマット）
- E-07: `ghost/core/core/server/services/slack-notifications/slack-notifications-service.js` 69-83行目（handleEvent()）
- E-08: `ghost/core/core/server/services/slack-notifications/slack-notifications-service.js` 85-89行目（subscribeEvents()）
- E-09: `ghost/core/core/server/services/slack-notifications/service.js` 41-57行目（init()）
- E-10: `ghost/core/core/server/services/slack-notifications/service.js` 47-52行目（hostSettings取得）
- E-11: `ghost/core/core/server/services/slack-notifications/slack-notifications.js` 107-134行目（blocks構築）
- E-12: `ghost/core/core/server/services/slack-notifications/slack-notifications.js` 158-166行目（URL検証）
- E-13: `ghost/core/core/server/services/slack-notifications/slack-notifications.js` 168-173行目（requestOptions）
- E-14: `ghost/core/core/server/services/slack-notifications/slack-notifications.js` 138行目（username設定）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | meta.reason=skipped/initialで送信スキップ | E-01 | ○ |
| C-02 | username「Ghost Milestone Service」 | E-14 | ○ |
| C-03 | unfurl_links: false | E-02 (137行目) | ○ |
| C-04 | Block Kit形式（attachments内blocks） | E-11 | ○ |
| C-05 | リトライ5回（本番）、0回（テスト） | E-04 | ○ |
| C-06 | validator.isURLでURL検証 | E-12 | ○ |
| C-07 | User-AgentにGhost/{version}設定 | E-13 (171行目) | ○ |
| C-08 | Intl.NumberFormatで通貨フォーマット | E-05 | ○ |
| C-09 | momentでD MMM YYYY形式に日付フォーマット | E-06 | ○ |
| C-10 | MilestoneCreatedEventをsubscribe | E-08 | ○ |
| C-11 | minThreshold比較でフィルタ | E-07 (75行目) | ○ |
| C-12 | hostSettings.milestones.urlから取得 | E-10 | ○ |
| C-13 | hostSettings.milestones.enabledで有効化判定 | E-09, E-10 | ○ |
| C-14 | エラー時はlogging.errorで記録、処理継続 | E-07 (79-81行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。主要な機能はすべてソースコードから根拠が取得できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にコードベースから直接根拠が取得できている
- 1: 中リスク - hostSettings依存のため、セルフホスト環境での動作は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] hostSettings.milestones設定の取得確認（service.js:47-52行目）
- [ ] minThreshold比較の演算子確認（`<`ではなく`>=`が正しいか）
- [ ] Intl.NumberFormat('en', ...)のロケール固定確認
- [ ] gotライブラリのリトライデフォルト動作確認
