---
generated_at: 2026-01-29 22:20:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-post.added

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. **署名生成ロジック**：HMAC-SHA256の実装確認
  2. **410レスポンス時の自動削除**：destroy()の挙動確認
  3. **customIntegrations制限**：limitService連携の確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/services/webhooks/listen.js` 10-45行目（WEBHOOKSイベント一覧）
- E-02: `ghost/core/core/server/services/webhooks/listen.js` 47-68行目（listen()関数）
- E-03: `ghost/core/core/server/services/webhooks/listen.js` 59-66行目（processWebhookTrigger）
- E-04: `ghost/core/core/server/services/webhooks/webhook-trigger.js` 23-49行目（getAll()）
- E-05: `ghost/core/core/server/services/webhooks/webhook-trigger.js` 98-143行目（trigger()）
- E-06: `ghost/core/core/server/services/webhooks/webhook-trigger.js` 51-62行目（update()）
- E-07: `ghost/core/core/server/services/webhooks/webhook-trigger.js` 64-71行目（destroy()）
- E-08: `ghost/core/core/server/services/webhooks/webhook-trigger.js` 81-96行目（onError()）
- E-09: `ghost/core/core/server/services/webhooks/webhook-trigger.js` 122-124行目（署名生成）
- E-10: `ghost/core/core/server/services/webhooks/webhook-trigger.js` 126-135行目（リクエストオプション）
- E-11: `ghost/core/core/server/services/webhooks/serialize.js` 全体（シリアライズ処理）
- E-12: `ghost/core/core/server/services/webhooks/payload.js` 全体（ペイロード生成）
- E-13: `ghost/core/core/server/models/webhook.js` 46-53行目（findAllByEvent()）
- E-14: `ghost/core/core/server/data/schema/schema.js` 353-370行目（webhooksテーブル）
- E-15: `ghost/core/core/server/services/webhooks/webhook-trigger.js` 116-120行目（ヘッダー設定）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | post.addedイベントはWEBHOOKS配列に含まれる | E-01 (13行目) | ○ |
| C-02 | importingフラグtrueで送信スキップ | E-03 (61-63行目) | ○ |
| C-03 | Webhook.findAllByEventでイベント別取得 | E-13 | ○ |
| C-04 | customIntegrations制限時はinternalのみ | E-04 (24-43行目) | ○ |
| C-05 | タイムアウト2000ms | E-10 (129-131行目) | ○ |
| C-06 | リトライ5回（本番）、0回（テスト） | E-10 (132-134行目) | ○ |
| C-07 | secret設定時にX-Ghost-Signature生成 | E-09 | ○ |
| C-08 | 署名形式: sha256={hash}, t={timestamp} | E-09 (123行目) | ○ |
| C-09 | 410レスポンスでWebhook自動削除 | E-08 (82-86行目), E-07 | ○ |
| C-10 | Content-Versionヘッダー付与 | E-15 (119行目) | ○ |
| C-11 | last_triggered_at/status/error更新 | E-06 (53-58行目) | ○ |
| C-12 | APIシリアライザーを再利用 | E-11 (29-35行目) | ○ |
| C-13 | current/previous形式のペイロード | E-11 (72-79行目) | ○ |
| C-14 | 重複リスナー登録防止 | E-02 (55-57行目) | ○ |
| C-15 | webhooksテーブルスキーマ | E-14 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。主要な機能はすべてソースコードから根拠が取得できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にコードベースから直接根拠が取得できている

## 6) レビュアーチェックリスト（最小）
- [ ] HMAC-SHA256署名のペイロード形式確認（payload + timestamp）
- [ ] 410レスポンス検出とdestroy()の連携確認
- [ ] customIntegrations制限のcheckWouldGoOverLimit()動作確認
- [ ] シリアライザーのwithRelated設定確認（tags, authors）
