---
generated_at: 2026-01-29 12:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：3-有料会員登録完了メール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **送信トリガーの詳細**：Stripe Webhook処理の詳細フローが未確認
  2. **送信タイミング**：checkout.session.completed以外のトリガーがあるか未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/members/emails/signup-paid.js` - 有料会員登録完了メールHTMLテンプレート
- E-02: 通知一覧.csv - 通知定義
- E-03: `ghost/core/core/server/services/members/members-api/members-api.js` - Members API（sendEmailWithMagicLink参照）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 有料サブスクリプション完了後にメール送信 | E-02 | ○ |
| C-02 | 件名は「Thank you for signing up to {siteTitle}!」 | E-01 (行9) | ○ |
| C-03 | 本文に「Thank you for subscribing to {siteTitle}」 | E-01 (行112, 122) | ○ |
| C-04 | 「Sign in」ボタンがある | E-01 (行130) | ○ |
| C-05 | リンクは24時間で有効期限切れ | E-01 (行138) | ○ |
| C-06 | テンプレート変数：siteTitle, email, url, accentColor, siteDomain, siteUrl | E-01 (行1) | ○ |
| C-07 | accentColorのデフォルトは#15212A | E-01 (行1) | ○ |
| C-08 | Stripe checkout.session.completedでトリガー | **根拠不足**（Stripe連携コードの詳細未確認） | △ |
| C-09 | 新規会員にのみ送信 | **根拠不足**（送信条件の詳細未確認） | △ |
| C-10 | signup.jsとは異なるテンプレート | E-01 vs signup.js | ○ |
| C-11 | preheaderに「Thank you for subscribing」 | E-01 (行112) | ○ |
| C-12 | フッターにサイトドメインとメールアドレス表示 | E-01 (行152) | ○ |
| C-13 | マジックリンクURL表示あり | E-01 (行142) | ○ |
| C-14 | sendEmailWithMagicLinkで送信 | E-03 | ○ |
| C-15 | HTML + テキストのマルチパート形式 | E-01（HTML構造確認） | ○ |

## 4) 不足情報（Unknown / Missing）
- **Stripe Webhook処理の詳細フロー**
  - checkout.session.completedイベントの処理フローを追跡する必要あり
  - 候補：`ghost/core/core/server/services/stripe/` 配下のファイル
- **送信条件の詳細**
  - 既存会員の追加サブスクリプション時の動作未確認
  - 候補：member-repository.js、stripe関連サービス

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: テンプレート構造、変数（コードで確認済み）
- **1（中リスク）**: 送信トリガー（Stripe連携部分の詳細未確認）
- **1（中リスク）**: 送信条件（新規会員のみの判定ロジック未確認）

## 6) レビュアーチェックリスト（最小）
- [ ] Stripe Webhook処理（checkout.session.completed）の実装を確認
- [ ] 新規会員と既存会員の追加サブスク時の動作差異を確認
- [ ] signup-paid.jsがどこで呼び出されるかの完全なパスを追跡
