---
generated_at: 2026-01-29 22:45:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-post.unpublished

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  1. **status変更の検出ロジック**：published→draftの判定確認
  2. **published_atのnullリセット**：挙動の確認

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/webhooks/listen.js` 18行目（post.unpublishedイベント定義）
- E-02: `ghost/core/core/server/services/webhooks/listen.js` 59-66行目（processWebhookTrigger）
- E-03: `ghost/core/core/server/services/webhooks/serialize.js` 71行目（_changed取得）
- E-04: `ghost/core/core/server/services/webhooks/serialize.js` 76行目（_.pick処理）
- E-05: `ghost/core/core/server/services/webhooks/serialize.js` 73-79行目（ペイロード構造）
- E-06: `ghost/core/core/server/services/webhooks/webhook-trigger.js` 98-143行目（trigger()）
- E-07: `ghost/core/core/server/models/webhook.js` 46-53行目（findAllByEvent）
- E-08: `ghost/core/core/server/data/schema/schema.js` 353-370行目（webhooksテーブル）
- E-09: `ghost/core/core/server/services/webhooks/webhook-trigger.js` 116-120行目（ヘッダー設定）
- E-10: `ghost/core/core/server/services/webhooks/webhook-trigger.js` 126-135行目（リクエストオプション）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | post.unpublishedイベントがWEBHOOKS配列に含まれる | E-01 | ○ |
| C-02 | importingフラグでスキップ | E-02 | ○ |
| C-03 | _changedから変更フィールドを取得 | E-03 | ○ |
| C-04 | _.pickで変更フィールドのみ抽出 | E-04 | ○ |
| C-05 | current/previous形式のペイロード | E-05 | ○ |
| C-06 | trigger()でHTTPリクエスト送信 | E-06 | ○ |
| C-07 | findAllByEventでイベント別取得 | E-07 | ○ |
| C-08 | webhooksテーブル構造 | E-08 | ○ |
| C-09 | Content-Versionヘッダー | E-09 | ○ |
| C-10 | タイムアウト2000ms、リトライ5回 | E-10 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Webhook共通基盤を使用

## 6) レビュアーチェックリスト（最小）
- [ ] status変更（published→draft）の検出ロジック確認
- [ ] published_atのnullリセット挙動確認
- [ ] post.deletedとの違いの理解（非公開vsデータ削除）
