---
generated_at: 2026-01-29 22:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：31-post.scheduled

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/services/webhooks/listen.js` 10-45行目（WEBHOOKS配列定義）
- E-02: `ghost/core/core/server/services/webhooks/listen.js` 59-66行目（イベントハンドラ）
- E-03: `ghost/core/core/server/services/webhooks/webhook-trigger.js` 98-143行目（trigger メソッド）
- E-04: `ghost/core/core/server/services/webhooks/webhook-trigger.js` 23-49行目（getAll メソッド）
- E-05: `ghost/core/core/server/services/webhooks/webhook-trigger.js` 116-124行目（ヘッダー・署名生成）
- E-06: `ghost/core/core/server/services/webhooks/webhook-trigger.js` 126-135行目（リトライ設定）
- E-07: `ghost/core/core/server/services/webhooks/webhook-trigger.js` 73-96行目（エラーハンドリング）
- E-08: `ghost/core/core/server/models/post.js` 378-392行目（onSaved イベント）
- E-09: `ghost/core/core/server/models/post.js` 394-464行目（onUpdated イベント）
- E-10: `ghost/core/core/server/models/post.js` 356-367行目（emitChange メソッド）
- E-11: `ghost/core/core/server/models/webhook.js` 46-52行目（findAllByEvent）
- E-12: `ghost/core/core/server/data/schema/schema.js` 353-370行目（webhooksテーブル定義）
- E-13: `ghost/core/core/server/data/schema/schema.js` 61-105行目（postsテーブル定義）
- E-14: `ghost/core/core/server/services/webhooks/payload.js` 1-16行目（ペイロード生成）
- E-15: `ghost/core/core/server/services/webhooks/serialize.js` 1-82行目（シリアライズ処理）
- E-16: `ghost/core/test/e2e-webhooks/posts.test.js` 313-362行目（post.scheduled テスト）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | post.scheduledはWEBHOOKS配列に含まれている | E-01（19行目） | ○ |
| C-02 | イベントリスナーでwebhookTrigger.triggerが呼ばれる | E-02 | ○ |
| C-03 | リトライ回数は本番5回、テスト0回 | E-06（133行目） | ○ |
| C-04 | タイムアウトは2000ms | E-03（130行目） | ○ |
| C-05 | 署名はHMAC-SHA256で生成される | E-05（123行目） | ○ |
| C-06 | Content-Typeはapplication/json | E-05（118行目） | ○ |
| C-07 | 410レスポンスでWebhookが削除される | E-07（83-87行目） | ○ |
| C-08 | onSavedでscheduledステータスならイベント発火 | E-08（389-391行目） | ○ |
| C-09 | onUpdatedでステータス変更時にscheduledイベント発火 | E-09（439-441行目） | ○ |
| C-10 | emitChangeでpost.scheduledイベントが発火 | E-10（364行目） | ○ |
| C-11 | findAllByEventでevent条件で検索 | E-11（51行目） | ○ |
| C-12 | webhooksテーブルにtarget_urlカラムが存在 | E-12（356行目） | ○ |
| C-13 | webhooksテーブルにsecretカラムが存在 | E-12（358行目） | ○ |
| C-14 | webhooksテーブルにlast_triggered_*カラムが存在 | E-12（365-367行目） | ○ |
| C-15 | postsテーブルにstatusカラムが存在 | E-13（74行目） | ○ |
| C-16 | ペイロードにcurrentとpreviousが含まれる | E-14, E-15（73-78行目） | ○ |
| C-17 | カスタムIntegration制限でフィルタリング | E-04（24-43行目） | ○ |
| C-18 | インポート中はWebhookをスキップ | E-02（61-63行目） | ○ |
| C-19 | 送信成功時にlast_triggered_*を更新 | E-07（73-78行目）、E-03（51-62行目） | ○ |
| C-20 | 送信失敗時にエラー情報を記録 | E-07（89-92行目） | ○ |
| C-21 | テストでpost.scheduledイベントが検証されている | E-16（313-362行目） | ○ |
| C-22 | ペイロードにauthors, tags, tiersが含まれる | E-15（11,23行目）、E-16（352-361行目） | ○ |
| C-23 | HTTPメソッドはPOST | E-03（139行目、this.request呼び出し） | ○ |
| C-24 | リソースタイプ変更時もscheduledイベント発火 | E-09（407-425行目） | ○ |
| C-25 | rescheduledとscheduledは別イベント | E-09（452-454行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張がソースコードにより根拠付けられている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] リトライ設定（5回）がビジネス要件と合致しているか確認
- [ ] タイムアウト（2000ms）が実運用で適切か確認
- [ ] 署名検証のドキュメントが受信側向けに提供されているか確認
