---
generated_at: 2026-01-29 22:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：32-post.unscheduled

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/webhooks/listen.js` 20行目（WEBHOOKS配列に'post.unscheduled'含む）
- E-02: `ghost/core/core/server/models/post.js` 400-401行目（wasScheduled判定）
- E-03: `ghost/core/core/server/models/post.js` 444-446行目（unscheduledイベント発火条件）
- E-04: `ghost/core/core/server/models/post.js` 412-414行目（リソースタイプ変更時のunscheduled）
- E-05: `ghost/core/core/server/services/webhooks/serialize.js` 43-64行目（previousAttributes取得）
- E-06: `ghost/core/test/e2e-webhooks/posts.test.js` 364-417行目（post.unscheduledテスト）
- E-07: `ghost/core/core/server/services/webhooks/webhook-trigger.js` 全体（送信処理）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | post.unscheduledはWEBHOOKS配列に含まれている | E-01 | ○ |
| C-02 | scheduledからdraftへの変更でトリガー | E-03 | ○ |
| C-03 | wasScheduled判定が行われる | E-02 | ○ |
| C-04 | publishedへの変更時はunscheduledが発火しない | E-03（条件: !isPublished） | ○ |
| C-05 | リソースタイプ変更時もunscheduledが発火する | E-04 | ○ |
| C-06 | previousにpublished_atが含まれる | E-05, E-06（テストスナップショット） | ○ |
| C-07 | currentにstatus='draft'が含まれる | E-06（テストで検証） | ○ |
| C-08 | リトライは5回 | E-07（133行目） | ○ |
| C-09 | タイムアウトは2000ms | E-07（130行目） | ○ |
| C-10 | 署名ヘッダーが付与される | E-07（122-124行目） | ○ |
| C-11 | Content-Typeはapplication/json | E-07（118行目） | ○ |
| C-12 | 410レスポンスでWebhookが削除される | E-07（83-87行目） | ○ |
| C-13 | インポート中はスキップされる | E-01（61-63行目） | ○ |
| C-14 | findAllByEventで検索される | E-07（104行目） | ○ |
| C-15 | テストでunscheduledイベントが検証されている | E-06 | ○ |
| C-16 | published_atがnullに変更される場合がある | E-06（387行目でnull設定） | ○ |
| C-17 | previousにupdated_atが含まれる | E-05（69行目）, E-06 | ○ |
| C-18 | tiersがペイロードに含まれる | E-06（スナップショット） | ○ |
| C-19 | HTTPメソッドはPOST | E-07（139行目） | ○ |
| C-20 | last_triggered_*が更新される | E-07（51-62行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張がソースコードにより根拠付けられている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] スケジュール解除後の外部システム連携が正しく動作するか確認
- [ ] published_atがnullになる場合の受信システム側のハンドリングを確認
- [ ] リソースタイプ変更（post→page）時の動作が期待通りか確認
