---
generated_at: 2026-01-29 22:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：33-post.rescheduled

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/webhooks/listen.js` 21行目（WEBHOOKS配列に'post.rescheduled'含む）
- E-02: `ghost/core/core/server/models/post.js` 403行目（publishedAtHasChanged判定）
- E-03: `ghost/core/core/server/models/post.js` 404行目（needsReschedule判定）
- E-04: `ghost/core/core/server/models/post.js` 452-454行目（rescheduledイベント発火条件）
- E-05: `ghost/core/core/server/services/webhooks/serialize.js` 43-64行目（previousAttributes取得）
- E-06: `ghost/core/test/e2e-webhooks/posts.test.js` 633-687行目（post.rescheduledテスト）
- E-07: `ghost/core/core/server/services/webhooks/webhook-trigger.js` 全体（送信処理）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | post.rescheduledはWEBHOOKS配列に含まれている | E-01 | ○ |
| C-02 | published_at変更でトリガー | E-02, E-03 | ○ |
| C-03 | statusがscheduledのまま維持されている必要がある | E-04（!statusChanging条件） | ○ |
| C-04 | needsReschedule判定式 | E-03（publishedAtHasChanged && isScheduled） | ○ |
| C-05 | previousにpublished_atが含まれる | E-05, E-06（テストスナップショット） | ○ |
| C-06 | currentにも新しいpublished_atが含まれる | E-06（テストで検証） | ○ |
| C-07 | リトライは5回 | E-07（133行目） | ○ |
| C-08 | タイムアウトは2000ms | E-07（130行目） | ○ |
| C-09 | 署名ヘッダーが付与される | E-07（122-124行目） | ○ |
| C-10 | Content-Typeはapplication/json | E-07（118行目） | ○ |
| C-11 | インポート中はスキップされる | E-01（61-63行目） | ○ |
| C-12 | テストでrescheduledイベントが検証されている | E-06 | ○ |
| C-13 | ステータス変更時は別イベントが発火 | E-04（else文脈内にある） | ○ |
| C-14 | post.editedも同時に発火する | E-04（458行目、直後にeditedイベント発火） | ○ |
| C-15 | HTTPメソッドはPOST | E-07（139行目） | ○ |
| C-16 | tiersがペイロードに含まれる | E-06（スナップショット） | ○ |
| C-17 | previousにupdated_atが含まれる | E-05, E-06 | ○ |
| C-18 | テストでは1日後から2日後への変更でテスト | E-06（641行目、657行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張がソースコードにより根拠付けられている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 公開予定日時の変更が正しく検知されるか確認
- [ ] 同時にpost.editedイベントも発火することを認識しているか確認
- [ ] 受信システムが新旧のpublished_atを適切に比較できるか確認
