---
generated_at: 2026-01-29 22:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：34-page.added

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/webhooks/listen.js` 23行目（WEBHOOKS配列に'page.added'含む）
- E-02: `ghost/core/core/server/models/post.js` 378-392行目（onSavedイベント）
- E-03: `ghost/core/core/server/models/post.js` 356-367行目（emitChangeメソッド）
- E-04: `ghost/core/core/server/models/post.js` 358行目（resourceType = this.get('type')）
- E-05: `ghost/core/core/server/data/schema/schema.js` 73行目（type: 'post'/'page'定義）
- E-06: `ghost/core/core/server/services/webhooks/serialize.js` 7-8行目（リソース名抽出）
- E-07: `ghost/core/test/e2e-webhooks/pages.test.js` 173-210行目（page.addedテスト）
- E-08: `ghost/core/core/server/services/webhooks/webhook-trigger.js` 全体（送信処理）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | page.addedはWEBHOOKS配列に含まれている | E-01 | ○ |
| C-02 | ページ作成時にpage.addedがトリガー | E-02, E-03 | ○ |
| C-03 | typeカラムで'page'を判定 | E-04, E-05 | ○ |
| C-04 | emitChangeでresourceTypeを取得 | E-03（358行目） | ○ |
| C-05 | イベント名は'page.added'形式で生成 | E-03（364行目） | ○ |
| C-06 | シリアライズでリソース名を抽出 | E-06 | ○ |
| C-07 | ペイロードのキーは'page' | E-06（74行目）, E-07 | ○ |
| C-08 | previousは空オブジェクト | E-07（スナップショット） | ○ |
| C-09 | リトライは5回 | E-08（133行目） | ○ |
| C-10 | タイムアウトは2000ms | E-08（130行目） | ○ |
| C-11 | 署名ヘッダーが付与される | E-08（122-124行目） | ○ |
| C-12 | Content-Typeはapplication/json | E-08（118行目） | ○ |
| C-13 | インポート中はスキップされる | E-01（61-63行目） | ○ |
| C-14 | テストでpage.addedイベントが検証されている | E-07 | ○ |
| C-15 | tiersがペイロードに含まれる | E-07（スナップショット） | ○ |
| C-16 | authorsがペイロードに含まれる | E-07（スナップショット） | ○ |
| C-17 | HTTPメソッドはPOST | E-08（139行目） | ○ |
| C-18 | publishedステータスで作成時は追加イベント発火 | E-02（389-391行目） | ○ |
| C-19 | リソースタイプ変更時にaddedイベント発火 | E-03（416-417行目） | ○ |
| C-20 | last_triggered_*が更新される | E-08（51-62行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張がソースコードにより根拠付けられている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] ページと投稿が同じテーブルで管理されていることを理解しているか確認
- [ ] 受信システムがpage/postの区別を適切に処理できるか確認
- [ ] 同時に発火する可能性のあるイベント（published, scheduled）の処理を確認
