---
generated_at: 2026-01-29 22:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：38-page.published.edited

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/webhooks/listen.js` 27行目（WEBHOOKS配列に'page.published.edited'含む）
- E-02: `ghost/core/core/server/models/post.js` 394-464行目（onUpdatedイベント）
- E-03: `ghost/core/core/server/models/post.js` 397行目（statusChanging判定）
- E-04: `ghost/core/core/server/models/post.js` 398行目（isPublished判定）
- E-05: `ghost/core/core/server/models/post.js` 448-450行目（published.editedイベント発火）
- E-06: `ghost/core/test/e2e-webhooks/pages.test.js` 361-410行目（page.published.editedテスト）
- E-07: `ghost/core/core/server/services/webhooks/webhook-trigger.js` 全体（送信処理）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | page.published.editedはWEBHOOKS配列に含まれている | E-01 | ○ |
| C-02 | 公開済みページ編集時にpublished.editedイベント発火 | E-05 | ○ |
| C-03 | statusChangingがfalseの場合に発火 | E-03, E-05（else文内） | ○ |
| C-04 | isPublishedがtrueの場合に発火 | E-04, E-05 | ○ |
| C-05 | ステータス変更時は発火しない | E-03, E-05（statusChanging条件） | ○ |
| C-06 | currentにstatus='published'が含まれる | E-06（スナップショット） | ○ |
| C-07 | previousに変更フィールドが含まれる | E-06（スナップショット） | ○ |
| C-08 | リトライは5回 | E-07（133行目） | ○ |
| C-09 | タイムアウトは2000ms | E-07（130行目） | ○ |
| C-10 | 署名ヘッダーが付与される | E-07（122-124行目） | ○ |
| C-11 | Content-Typeはapplication/json | E-07（118行目） | ○ |
| C-12 | インポート中はスキップされる | E-01（61-63行目） | ○ |
| C-13 | テストでpage.published.editedイベントが検証されている | E-06 | ○ |
| C-14 | tiersがペイロードに含まれる | E-06（スナップショット） | ○ |
| C-15 | page.editedも同時に発火する | E-02（457-458行目でedited発火） | ○ |
| C-16 | HTTPメソッドはPOST | E-07（139行目） | ○ |
| C-17 | published_atがペイロードに含まれる | E-06（スナップショット） | ○ |
| C-18 | authorsがペイロードに含まれる | E-06（スナップショット） | ○ |
| C-19 | ペイロードのキーは'page' | E-06（スナップショット） | ○ |
| C-20 | last_triggered_*が更新される | E-07（51-62行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張がソースコードにより根拠付けられている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] CDNキャッシュパージなど即時性が必要な処理が正しく動作するか確認
- [ ] page.editedも同時に発火することを認識しているか確認
- [ ] ステータス変更時は別イベント（published/unpublished）が発火することを理解しているか確認
