---
generated_at: 2026-01-29 22:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：39-page.unpublished

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/webhooks/listen.js` 28行目（WEBHOOKS配列に'page.unpublished'含む）
- E-02: `ghost/core/core/server/models/post.js` 394-464行目（onUpdatedイベント）
- E-03: `ghost/core/core/server/models/post.js` 400行目（wasPublished判定）
- E-04: `ghost/core/core/server/models/post.js` 427-431行目（ステータス変更時のunpublished発火）
- E-05: `ghost/core/core/server/models/post.js` 408-410行目（リソースタイプ変更時のunpublished発火）
- E-06: `ghost/core/core/server/models/post.js` 466-474行目（削除時のunpublished発火）
- E-07: `ghost/core/test/e2e-webhooks/pages.test.js` 412-461行目（page.unpublishedテスト）
- E-08: `ghost/core/core/server/services/webhooks/webhook-trigger.js` 全体（送信処理）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | page.unpublishedはWEBHOOKS配列に含まれている | E-01 | ○ |
| C-02 | publishedからdraftへの変更でunpublishedイベント発火 | E-04 | ○ |
| C-03 | wasPublished判定が行われる | E-03 | ○ |
| C-04 | 削除時にpublishedだった場合もunpublished発火 | E-06（469-471行目） | ○ |
| C-05 | リソースタイプ変更時もunpublished発火 | E-05 | ○ |
| C-06 | previousにstatus='published'が含まれる | E-07（スナップショット） | ○ |
| C-07 | currentにstatus='draft'が含まれる | E-07（スナップショット） | ○ |
| C-08 | リトライは5回 | E-08（133行目） | ○ |
| C-09 | タイムアウトは2000ms | E-08（130行目） | ○ |
| C-10 | 署名ヘッダーが付与される | E-08（122-124行目） | ○ |
| C-11 | Content-Typeはapplication/json | E-08（118行目） | ○ |
| C-12 | インポート中はスキップされる | E-01（61-63行目） | ○ |
| C-13 | テストでpage.unpublishedイベントが検証されている | E-07 | ○ |
| C-14 | tiersがペイロードに含まれる | E-07（スナップショット） | ○ |
| C-15 | page.editedも同時に発火する（削除時を除く） | E-02（457-458行目） | ○ |
| C-16 | HTTPメソッドはPOST | E-08（139行目） | ○ |
| C-17 | 削除時はunpublishedが先に発火してからdeleted | E-06（順序確認） | ○ |
| C-18 | authorsがペイロードに含まれる | E-07（スナップショット） | ○ |
| C-19 | ペイロードのキーは'page' | E-07（スナップショット） | ○ |
| C-20 | last_triggered_*が更新される | E-08（51-62行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張がソースコードにより根拠付けられている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 非公開イベントを受けた外部システム（検索インデックス削除等）が正しく動作するか確認
- [ ] 削除時のunpublished + deletedの2イベント発火を認識しているか確認
- [ ] リソースタイプ変更時の動作を理解しているか確認
