---
generated_at: 2026-01-29 12:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-購読確認メール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/members/emails/subscribe.js` - 購読確認メールHTMLテンプレート
- E-02: `ghost/core/core/server/services/members/members-api/controllers/router-controller.js` - APIコントローラー
- E-03: 通知一覧.csv - 通知定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ニュースレター購読確認メールが送信される | E-01, E-03 | ○ |
| C-02 | 件名は「Confirm your subscription to {siteTitle}」 | E-01 (行9) | ○ |
| C-03 | preheaderに「You're one tap away from subscribing」 | E-01 (行112) | ○ |
| C-04 | 本文に「please confirm your email address with this link」 | E-01 (行122) | ○ |
| C-05 | 「Confirm email address」ボタンがある | E-01 (行130) | ○ |
| C-06 | リンクは24時間で有効期限切れ | E-01 (行138) | ○ |
| C-07 | 「All the best!」の署名 | E-01 (行139) | ○ |
| C-08 | フッターに「You will not be subscribed」の注意書き | E-01 (行153) | ○ |
| C-09 | テンプレート変数：siteTitle, email, url, accentColor, siteDomain, siteUrl | E-01 (行1) | ○ |
| C-10 | accentColorのデフォルトは#15212A | E-01 (行1) | ○ |
| C-11 | emailType='subscribe'でトリガー | E-02 (行716-719) | ○ |
| C-12 | subscribeはsignupと同様に_handleSignupで処理 | E-02 (行725-726) | ○ |
| C-13 | 既存会員はsigninにフォールバック | E-02, members-api.js (行229-230) | ○ |
| C-14 | セルフサインアップ許可チェックあり | E-02 (行824-834) | ○ |
| C-15 | ブロックドメインチェックあり | E-02 (行836-842) | ○ |
| C-16 | sniperLinksがレスポンスに含まれる | E-02 (行734-741) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主要な主張に対して根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: すべての主張に根拠あり
- **0（低リスク）**: テンプレート構造、件名、本文
- **0（低リスク）**: トリガー条件、フォールバック動作

## 6) レビュアーチェックリスト（最小）
- [ ] subscribeタイプのリクエストでnewsletters情報が正しく含まれることを確認
- [ ] 購読確認完了後のニュースレター購読設定の反映を確認
- [ ] signup.jsとsubscribe.jsの使い分け条件を確認
