---
generated_at: 2026-01-29 22:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：40-page.scheduled

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/webhooks/listen.js` 29行目（WEBHOOKS配列に'page.scheduled'含む）
- E-02: `ghost/core/core/server/models/post.js` 378-392行目（onSavedイベント）
- E-03: `ghost/core/core/server/models/post.js` 389-391行目（新規作成時のscheduled発火）
- E-04: `ghost/core/core/server/models/post.js` 399行目（isScheduled判定）
- E-05: `ghost/core/core/server/models/post.js` 439-441行目（更新時のscheduled発火）
- E-06: `ghost/core/core/server/models/post.js` 356-367行目（emitChangeメソッド、resourceType判定）
- E-07: `ghost/core/core/server/data/schema/schema.js` 73行目（type: 'post'/'page'定義）
- E-08: `ghost/core/test/e2e-webhooks/pages.test.js` 309-359行目（page.scheduledテスト）
- E-09: `ghost/core/core/server/services/webhooks/webhook-trigger.js` 全体（送信処理）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | page.scheduledはWEBHOOKS配列に含まれている | E-01 | ○ |
| C-02 | 新規作成時にscheduledステータスでscheduledイベント発火 | E-02, E-03 | ○ |
| C-03 | 更新時にscheduledへの変更でscheduledイベント発火 | E-05 | ○ |
| C-04 | isScheduled判定がステータス確認に使用 | E-04 | ○ |
| C-05 | emitChangeでresourceTypeを取得 | E-06（358行目） | ○ |
| C-06 | イベント名は'page.scheduled'形式で生成 | E-06（364行目） | ○ |
| C-07 | typeカラムで'page'を判定 | E-07 | ○ |
| C-08 | currentにstatus='scheduled'が含まれる | E-08（スナップショット） | ○ |
| C-09 | currentにpublished_atが含まれる | E-08（スナップショット） | ○ |
| C-10 | リトライは5回 | E-09（133行目） | ○ |
| C-11 | タイムアウトは2000ms | E-09（130行目） | ○ |
| C-12 | 署名ヘッダーが付与される | E-09（122-124行目） | ○ |
| C-13 | Content-Typeはapplication/json | E-09（118行目） | ○ |
| C-14 | インポート中はスキップされる | E-01（61-63行目） | ○ |
| C-15 | テストでpage.scheduledイベントが検証されている | E-08 | ○ |
| C-16 | tiersがペイロードに含まれる | E-08（スナップショット） | ○ |
| C-17 | authorsがペイロードに含まれる | E-08（スナップショット） | ○ |
| C-18 | HTTPメソッドはPOST | E-09（139行目） | ○ |
| C-19 | 新規作成時はaddedとscheduledの両方発火 | E-02（387行目でadded、389-391行目でscheduled） | ○ |
| C-20 | ペイロードのキーは'page' | E-08（スナップショット） | ○ |
| C-21 | last_triggered_*が更新される | E-09（51-62行目） | ○ |
| C-22 | リソースタイプ変更時もscheduledイベント発火 | E-06（423-425行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張がソースコードにより根拠付けられている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] スケジュールイベントを受けた外部システムの処理が正しく動作するか確認
- [ ] 新規作成時のadded + scheduledの2イベント発火を認識しているか確認
- [ ] published_at（公開予定日時）が正しく設定されているか確認
- [ ] rescheduledとの違い（日時変更 vs 初回スケジュール）を理解しているか確認
