---
generated_at: 2026-01-29 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：41-page.unscheduled

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **リトライ間隔の詳細**: @tryghost/requestのデフォルト設定の具体値が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/services/webhooks/listen.js` (10-68行目)
- E-02: `ghost/core/core/server/services/webhooks/webhook-trigger.js` (1-147行目)
- E-03: `ghost/core/core/server/services/webhooks/payload.js` (1-17行目)
- E-04: `ghost/core/core/server/services/webhooks/serialize.js` (1-82行目)
- E-05: `ghost/core/core/server/models/post.js` (356-464行目)
- E-06: `ghost/core/core/server/models/webhook.js` (1-86行目)
- E-07: `ghost/core/core/server/data/schema/schema.js` (353-370行目 webhooks, 61-105行目 posts)
- E-08: `ghost/core/core/server/lib/common/events.js` (1-34行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | page.unscheduledイベントがWEBHOOKSリストに定義されている | E-01 (30行目) | ○ |
| C-02 | ページステータスがscheduledから変更時にunscheduledイベントが発火 | E-05 (444-446行目) | ○ |
| C-03 | wasScheduled && !isScheduled && !isPublished の条件でイベント発火 | E-05 (444行目) | ○ |
| C-04 | emitChangeでresourceType + '.' + eventのイベント名を構成 | E-05 (356-366行目) | ○ |
| C-05 | webhooksテーブルからevent一致するレコードを取得 | E-06 (46-53行目) | ○ |
| C-06 | リトライ回数は5回（本番）、0回（テスト） | E-02 (133-134行目) | ○ |
| C-07 | タイムアウトは2000ms（2秒） | E-02 (129-131行目) | ○ |
| C-08 | Content-Typeはapplication/json | E-02 (118行目) | ○ |
| C-09 | Content-VersionにGhost APIバージョンを含む | E-02 (119行目) | ○ |
| C-10 | secretが設定されている場合X-Ghost-Signatureヘッダーを付与 | E-02 (122-124行目) | ○ |
| C-11 | 署名はHMAC-SHA256(payload + timestamp, secret)で生成 | E-02 (123行目) | ○ |
| C-12 | 410レスポンスでWebhookを削除 | E-02 (83-86行目) | ○ |
| C-13 | 送信結果をlast_triggered_at, last_triggered_statusに記録 | E-02 (51-61行目) | ○ |
| C-14 | ペイロードにcurrentとpreviousを含む | E-04 (73-78行目) | ○ |
| C-15 | previousには変更されたフィールドのみ含まれる | E-04 (76行目) | ○ |
| C-16 | postsテーブルのtype='page'でページを識別 | E-07 (73行目) | ○ |
| C-17 | webhooksテーブルにevent, target_url, secretカラムが存在 | E-07 (354-358行目) | ○ |
| C-18 | integration_idでインテグレーションと紐付け | E-07 (364行目), E-06 (19-21行目) | ○ |
| C-19 | customIntegrations制限で内部インテグレーションのみ対象にできる | E-02 (24-43行目) | ○ |
| C-20 | options.importingがtrueの場合は送信しない | E-01 (61-63行目) | ○ |
| C-21 | EventRegistryはevents.EventEmitterを継承 | E-08 (16-28行目) | ○ |
| C-22 | hasRegisteredListenerで重複登録を防止 | E-08 (25-27行目), E-01 (55-57行目) | ○ |
| C-23 | postsとpagesのシリアライズにtags, authorsを含む | E-04 (11, 23行目) | ○ |
| C-24 | htmlとplaintextフォーマットをサポート | E-04 (10行目) | ○ |
| C-25 | リトライ間隔は@tryghost/requestのデフォルト設定に従う | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **リトライ間隔の具体値**: @tryghost/requestパッケージの内部実装に依存しており、具体的な間隔（指数バックオフなど）は外部パッケージのコードを確認する必要がある
  - 候補: @tryghost/requestのソースコード / got パッケージのデフォルト設定 / ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - イベント発火条件、ペイロード構造は明確にコードで確認可能
- 0: 低リスク - Webhook送信処理は標準的なHTTP POSTで実装されている
- 1: 中リスク - リトライ間隔の具体値は外部依存のため要確認

## 6) レビュアーチェックリスト（最小）
- [ ] E-05 (post.js:444-446) の条件ロジックが設計書の記載と一致しているか確認
- [ ] E-02 (webhook-trigger.js) の署名生成ロジックが正確に記載されているか確認
- [ ] @tryghost/requestパッケージのリトライ設定を必要に応じて調査
- [ ] ペイロード構造のサンプルが実際のシリアライズ出力と一致するか確認
