---
generated_at: 2026-01-29 10:35:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：42-page.rescheduled

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **リトライ間隔の詳細**: @tryghost/requestのデフォルト設定の具体値が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/services/webhooks/listen.js` (10-68行目)
- E-02: `ghost/core/core/server/services/webhooks/webhook-trigger.js` (1-147行目)
- E-03: `ghost/core/core/server/services/webhooks/payload.js` (1-17行目)
- E-04: `ghost/core/core/server/services/webhooks/serialize.js` (1-82行目)
- E-05: `ghost/core/core/server/models/post.js` (356-464行目)
- E-06: `ghost/core/core/server/models/webhook.js` (1-86行目)
- E-07: `ghost/core/core/server/data/schema/schema.js` (353-370行目 webhooks, 61-105行目 posts)
- E-08: `ghost/core/core/server/lib/common/events.js` (1-34行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | page.rescheduledイベントがWEBHOOKSリストに定義されている | E-01 (31行目) | ○ |
| C-02 | needsReschedule = publishedAtHasChanged && isScheduled で判定 | E-05 (404行目) | ○ |
| C-03 | publishedAtHasChangedで公開日時の変更を検出 | E-05 (403行目) | ○ |
| C-04 | needsRescheduleが真の場合にrescheduledイベントを発火 | E-05 (452-454行目) | ○ |
| C-05 | emitChangeでresourceType + '.' + eventのイベント名を構成 | E-05 (356-366行目) | ○ |
| C-06 | webhooksテーブルからevent一致するレコードを取得 | E-06 (46-53行目) | ○ |
| C-07 | リトライ回数は5回（本番）、0回（テスト） | E-02 (133-134行目) | ○ |
| C-08 | タイムアウトは2000ms（2秒） | E-02 (129-131行目) | ○ |
| C-09 | Content-Typeはapplication/json | E-02 (118行目) | ○ |
| C-10 | secretが設定されている場合X-Ghost-Signatureヘッダーを付与 | E-02 (122-124行目) | ○ |
| C-11 | 410レスポンスでWebhookを削除 | E-02 (83-86行目) | ○ |
| C-12 | 送信結果をlast_triggered_at, last_triggered_statusに記録 | E-02 (51-61行目) | ○ |
| C-13 | ペイロードにcurrentとpreviousを含む | E-04 (73-78行目) | ○ |
| C-14 | previousには変更されたフィールドのみ含まれる | E-04 (76行目) | ○ |
| C-15 | postsテーブルのtype='page'でページを識別 | E-07 (73行目) | ○ |
| C-16 | webhooksテーブルにevent, target_url, secretカラムが存在 | E-07 (354-358行目) | ○ |
| C-17 | postsテーブルにpublished_atカラムが存在 | E-07 (90行目) | ○ |
| C-18 | options.importingがtrueの場合は送信しない | E-01 (61-63行目) | ○ |
| C-19 | statusChangingの場合は別のイベント処理が優先される | E-05 (427-456行目) | ○ |
| C-20 | isScheduledはstatus === 'scheduled'で判定 | E-05 (399行目) | ○ |
| C-21 | ステータス変更なしの場合にrescheduledイベントが処理される | E-05 (447-456行目) | ○ |
| C-22 | postsとpagesのシリアライズにtags, authorsを含む | E-04 (11, 23行目) | ○ |
| C-23 | htmlとplaintextフォーマットをサポート | E-04 (10行目) | ○ |
| C-24 | リトライ間隔は@tryghost/requestのデフォルト設定に従う | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **リトライ間隔の具体値**: @tryghost/requestパッケージの内部実装に依存しており、具体的な間隔（指数バックオフなど）は外部パッケージのコードを確認する必要がある
  - 候補: @tryghost/requestのソースコード / got パッケージのデフォルト設定 / ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - イベント発火条件（needsReschedule）は明確にコードで確認可能
- 0: 低リスク - published_atの変更検出ロジックはhasDateChangedメソッドで実装
- 1: 中リスク - リトライ間隔の具体値は外部依存のため要確認

## 6) レビュアーチェックリスト（最小）
- [ ] E-05 (post.js:404) のneedsReschedule計算ロジックが設計書の記載と一致しているか確認
- [ ] E-05 (post.js:452-454) のrescheduledイベント発火条件を確認
- [ ] hasDateChangedメソッドの実装を確認（post.js内またはベースモデル）
- [ ] ペイロードにpublished_atの変更前後の値が含まれることを確認
