---
generated_at: 2026-01-29 10:55:00
metrics:
  claims_total: 23
  claims_with_evidence: 22
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：46-member.added

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：22 / 23、根拠なし：1
- 優先レビュー（高）
  1. **リトライ間隔の詳細**: @tryghost/requestのデフォルト設定の具体値が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/services/webhooks/listen.js` (10-68行目)
- E-02: `ghost/core/core/server/services/webhooks/webhook-trigger.js` (1-147行目)
- E-03: `ghost/core/core/server/services/webhooks/payload.js` (1-17行目)
- E-04: `ghost/core/core/server/services/webhooks/serialize.js` (1-82行目)
- E-05: `ghost/core/core/server/models/member.js` (1-503行目)
- E-06: `ghost/core/core/server/models/webhook.js` (1-86行目)
- E-07: `ghost/core/core/server/data/schema/schema.js` (417-444行目 members, 353-370行目 webhooks)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | member.addedイベントがWEBHOOKSリストに定義されている | E-01 (37行目) | ○ |
| C-02 | Member.onCreatedでemitChange('added')が呼ばれる | E-05 (255-259行目) | ○ |
| C-03 | emitChangeで'member.' + eventのイベント名を構成 | E-05 (250-252行目) | ○ |
| C-04 | webhooksテーブルからevent一致するレコードを取得 | E-06 (46-53行目) | ○ |
| C-05 | リトライ回数は5回（本番）、0回（テスト） | E-02 (133-134行目) | ○ |
| C-06 | タイムアウトは2000ms（2秒） | E-02 (129-131行目) | ○ |
| C-07 | ペイロードにcurrentとpreviousを含む | E-04 (73-78行目) | ○ |
| C-08 | デフォルトstatusは'free' | E-05 (15行目) | ○ |
| C-09 | uuid, transient_idは自動生成 | E-05 (16-17行目) | ○ |
| C-10 | デフォルトでenable_comment_notifications=true | E-05 (20行目) | ○ |
| C-11 | membersテーブルにstatusカラム（free/paid/comped）が存在 | E-07 (422-426行目) | ○ |
| C-12 | membersテーブルにemail, name, noteカラムが存在 | E-07 (421, 427-429行目) | ○ |
| C-13 | membersテーブルにemail_count, email_opened_countカラムが存在 | E-07 (432-433行目) | ○ |
| C-14 | secretが設定されている場合X-Ghost-Signatureヘッダーを付与 | E-02 (122-124行目) | ○ |
| C-15 | 410レスポンスでWebhookを削除 | E-02 (83-86行目) | ○ |
| C-16 | options.importingがtrueの場合は送信しない | E-01 (61-63行目) | ○ |
| C-17 | Content-Typeはapplication/json | E-02 (118行目) | ○ |
| C-18 | resourceNameはeventから正規表現で抽出 | E-04 (7行目) | ○ |
| C-19 | docNameはresourceName + 's'で構成 | E-04 (8行目) | ○ |
| C-20 | membersテーブルにgeolocationカラムが存在 | E-07 (430行目) | ○ |
| C-21 | membersテーブルにlast_seen_atカラムが存在 | E-07 (436行目) | ○ |
| C-22 | Memberモデルにlabels関連が定義されている | E-05 (141, 197-206行目) | ○ |
| C-23 | リトライ間隔は@tryghost/requestのデフォルト設定に従う | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **リトライ間隔の具体値**: @tryghost/requestパッケージの内部実装に依存しており、具体的な間隔は外部パッケージのコードを確認する必要がある
  - 候補: @tryghost/requestのソースコード / got パッケージのデフォルト設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Member.onCreatedの実装は明確でシンプル
- 0: 低リスク - membersテーブルのスキーマは詳細に定義されている
- 0: 低リスク - インポート時の抑止条件は明確
- 1: 中リスク - リトライ間隔の具体値は外部依存のため要確認

## 6) レビュアーチェックリスト（最小）
- [ ] E-05 (member.js:255-259) のonCreated実装が設計書の記載と一致しているか確認
- [ ] E-05 (member.js:13-21) のdefaults設定を確認
- [ ] E-07のmembersテーブル定義とペイロード構造の整合性を確認
- [ ] インポート時（options.importing=true）にWebhookが発火しないことを確認
